/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.MojoUtils;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.ToolchainManager;

public class DefaultServerFactory
implements ServerFactory {
    private final Log log;
    private final ToolchainManager toolchainManager;
    private final MavenSession mavenSession;
    private final AtomicBoolean serverStarted;
    private final String testResourcesVersion;
    private Process process;

    public DefaultServerFactory(Log log, ToolchainManager toolchainManager, MavenSession mavenSession, AtomicBoolean serverStarted, String testResourcesVersion) {
        this.log = log;
        this.toolchainManager = toolchainManager;
        this.mavenSession = mavenSession;
        this.serverStarted = serverStarted;
        this.testResourcesVersion = testResourcesVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(ServerUtils.ProcessParameters processParameters) {
        this.log.info((CharSequence)("Starting Micronaut Test Resources service, version " + this.testResourcesVersion));
        String javaBin = MojoUtils.findJavaExecutable(this.toolchainManager, this.mavenSession);
        ArrayList<String> cli = new ArrayList<String>();
        cli.add(javaBin);
        cli.addAll(processParameters.getJvmArguments());
        processParameters.getSystemProperties().forEach((key, value) -> cli.add("-D" + key + "=" + value));
        cli.add("-cp");
        cli.add(processParameters.getClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        cli.add(processParameters.getMainClass());
        cli.addAll(processParameters.getArguments());
        ProcessBuilder builder = new ProcessBuilder(cli);
        try {
            this.process = builder.inheritIO().start();
        }
        catch (Exception e) {
            this.serverStarted.set(false);
            this.process.destroyForcibly();
        }
        finally {
            if (this.process.isAlive()) {
                this.serverStarted.set(true);
            } else {
                this.process.destroyForcibly();
            }
        }
    }

    public void waitFor(Duration duration) throws InterruptedException {
        if (this.process != null) {
            this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

