/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import com.github.dockerjava.api.command.BuildImageCmd;
import io.micronaut.maven.AbstractDockerMojo;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="docker", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerMojo
extends AbstractDockerMojo {
    public static final String DOCKER_PACKAGING = "docker";

    @Inject
    public DockerMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService, MavenSession mavenSession, MojoExecution mojoExecution) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService, mavenSession, mojoExecution);
    }

    public void execute() throws MojoExecutionException {
        File dockerfile = new File(this.mavenProject.getBasedir(), "Dockerfile");
        if (dockerfile.exists()) {
            try {
                this.getLog().info((CharSequence)("Using provided Dockerfile: " + dockerfile.getAbsolutePath()));
                this.mavenProject.getProperties().put("jib.skip", "true");
                this.copyDependencies();
                String targetDir = this.mavenProject.getBuild().getDirectory();
                File targetDockerfile = new File(targetDir, dockerfile.getName());
                Files.copy(dockerfile.toPath(), targetDockerfile.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
                BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd().withDockerfile(targetDockerfile).withTags(this.getTags()).withBaseDirectory(new File(targetDir));
                this.getNetworkMode().ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withNetworkMode(arg_0));
                this.dockerService.buildImage(buildImageCmd);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else if (this.jibConfigurationService.getFromImage().isEmpty()) {
            this.mavenProject.getProperties().setProperty("jib.from.image", "eclipse-temurin:17-alpine");
        }
    }
}

