/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.openapi;

import io.micronaut.maven.AbstractMicronautMojo;
import io.micronaut.maven.openapi.ParameterMapping;
import io.micronaut.maven.openapi.ResponseBodyMapping;
import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import io.micronaut.openapi.generator.MicronautCodeGeneratorEntryPoint;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractOpenApiMojo
extends AbstractMicronautMojo {
    static final String MICRONAUT_OPENAPI_PREFIX = "micronaut.openapi";
    static final String IO_MICRONAUT_OPENAPI_PREFIX = "io.micronaut.openapi";
    @Parameter(property="micronaut.openapi.definition", defaultValue="io.micronaut.openapi.invoker", required=true)
    protected File definitionFile;
    @Parameter(property="micronaut.openapi.invoker.package.name", defaultValue="io.micronaut.openapi.invoker", required=true)
    protected String invokerPackageName;
    @Parameter(property="micronaut.openapi.api.package.name", defaultValue="io.micronaut.openapi.api", required=true)
    protected String apiPackageName;
    @Parameter(property="micronaut.openapi.model.package.name", defaultValue="io.micronaut.openapi.model", required=true)
    protected String modelPackageName;
    @Parameter(property="micronaut.openapi.use.bean.validation", defaultValue="true", required=true)
    protected boolean useBeanValidation;
    @Parameter(property="micronaut.openapi.use.optional", defaultValue="false", required=true)
    protected boolean useOptional;
    @Parameter(property="micronaut.openapi.use.reactive", defaultValue="true", required=true)
    protected boolean useReactive;
    @Parameter(property="micronaut.openapi.outputs", required=true, defaultValue="apis,models,supporting_files")
    protected List<String> outputKinds;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/openapi", required=true)
    protected File outputDirectory;
    @Parameter(property="micronaut.openapi.parameterMappings")
    protected List<ParameterMapping> parameterMappings;
    @Parameter(property="micronaut.openapi.responseBodyMappings")
    protected List<ResponseBodyMapping> responseBodyMappings;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    protected abstract boolean isEnabled();

    protected abstract void configureBuilder(MicronautCodeGeneratorBuilder var1) throws MojoExecutionException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isEnabled()) {
            this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " is disabled"));
            return;
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        MicronautCodeGeneratorBuilder builder = MicronautCodeGeneratorEntryPoint.builder().withDefinitionFile(this.definitionFile.toURI()).withOutputDirectory(this.outputDirectory).withOutputs(this.outputKinds.stream().map(String::toUpperCase).map(MicronautCodeGeneratorEntryPoint.OutputKind::valueOf).toList().toArray(new MicronautCodeGeneratorEntryPoint.OutputKind[0])).withOptions(options -> {
            options.withInvokerPackage(this.invokerPackageName);
            options.withApiPackage(this.apiPackageName);
            options.withModelPackage(this.modelPackageName);
            options.withBeanValidation(this.useBeanValidation);
            options.withOptional(this.useOptional);
            options.withReactive(this.useReactive);
            options.withSerializationLibrary(SerializationLibraryKind.MICRONAUT_SERDE_JACKSON);
            options.withParameterMappings(this.parameterMappings.stream().map(mapping -> new AbstractMicronautJavaCodegen.ParameterMapping(mapping.getName(), AbstractMicronautJavaCodegen.ParameterMapping.ParameterLocation.valueOf((String)mapping.getLocation().name()), mapping.getMappedType(), mapping.getMappedName(), mapping.isValidated())).collect(Collectors.toList()));
            options.withResponseBodyMappings(this.responseBodyMappings.stream().map(mapping -> new AbstractMicronautJavaCodegen.ResponseBodyMapping(mapping.getHeaderName(), mapping.getMappedBodyType(), mapping.isListWrapper(), mapping.isValidated())).collect(Collectors.toList()));
        });
        this.configureBuilder(builder);
        builder.build().generate();
    }
}

