/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.JansiLog;
import io.micronaut.maven.testresources.TestResourcesConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractTestResourcesMojo
extends TestResourcesConfiguration
implements Mojo,
ContextEnabled {
    private static final String DEFAULT_CLASSPATH_INFERENCE = "true";
    private static final String DEFAULT_CLIENT_TIMEOUT = "60";
    protected Log log;
    protected Map<?, ?> pluginContext;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File buildDirectory;
    @Parameter(property="micronaut.test.resources.version", required=true)
    protected String testResourcesVersion;
    @Parameter(defaultValue="true")
    protected Boolean classpathInference = Boolean.valueOf("true");
    @Parameter
    protected List<Dependency> testResourcesDependencies;
    @Parameter(property="micronaut.test.resources.port")
    protected Integer explicitPort;
    @Parameter(property="micronaut.test.resources.client-timeout", defaultValue="60")
    protected Integer clientTimeout = Integer.valueOf("60");

    public static Path serverSettingsDirectoryOf(Path buildDir) {
        return buildDir.resolve("../.micronaut/test-resources");
    }

    public void setLog(Log log) {
        this.log = new JansiLog(log);
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public Map<?, ?> getPluginContext() {
        return this.pluginContext;
    }

    public void setPluginContext(Map pluginContext) {
        this.pluginContext = pluginContext;
    }
}

