/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.google.cloud.tools.jib.api.Credential;
import io.micronaut.maven.AbstractDockerMojo;
import io.micronaut.maven.Packaging;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="docker-push")
public class DockerPushMojo
extends AbstractDockerMojo {
    @Inject
    public DockerPushMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService, MavenSession mavenSession, MojoExecution mojoExecution) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService, mavenSession, mojoExecution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Packaging packaging = Packaging.of(this.mavenProject.getPackaging());
        if (packaging != Packaging.DOCKER && packaging != Packaging.DOCKER_NATIVE && packaging != Packaging.DOCKER_CRAC) throw new MojoFailureException("The <packaging> must be set to either [" + Packaging.DOCKER.id() + "] or [" + Packaging.DOCKER_NATIVE.id() + "]");
        Set<String> images = this.getTags();
        if (!this.jibConfigurationService.getToImage().isPresent()) throw new MojoFailureException("The plugin com.google.cloud.tools:jib-maven-plugin is misconfigured. Missing <to> tag");
        for (String taggedImage : images) {
            this.getLog().info((CharSequence)("Pushing image: " + taggedImage));
            try {
                PushImageCmd pushImageCmd = this.dockerService.pushImageCmd(taggedImage);
                try {
                    Optional toCredentials = this.jibConfigurationService.getToCredentials();
                    if (toCredentials.isPresent()) {
                        Credential credential = (Credential)toCredentials.get();
                        AuthConfig authConfig = this.dockerService.getAuthConfigFor(taggedImage, credential.getUsername(), credential.getPassword());
                        pushImageCmd.withAuthConfig(authConfig);
                    }
                    pushImageCmd.start().awaitCompletion();
                }
                finally {
                    if (pushImageCmd == null) continue;
                    pushImageCmd.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

