/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import io.micronaut.maven.AbstractDockerMojo;
import io.micronaut.maven.MojoUtils;
import io.micronaut.maven.Packaging;
import io.micronaut.maven.core.DockerBuildStrategy;
import io.micronaut.maven.core.MicronautRuntime;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.jib.JibMicronautExtension;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import io.micronaut.maven.services.ExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="dockerfile", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerfileMojo
extends AbstractDockerMojo {
    public static final String DOCKERFILE = "Dockerfile";
    public static final String DOCKERFILE_AWS_CUSTOM_RUNTIME = "DockerfileAwsCustomRuntime";
    public static final String DOCKERFILE_NATIVE = "DockerfileNative";
    public static final String DOCKERFILE_CRAC = "DockerfileCrac";
    public static final String DOCKERFILE_CRAC_CHECKPOINT = "DockerfileCracCheckpoint";
    public static final String DOCKERFILE_CRAC_CHECKPOINT_FILE = "Dockerfile.crac.checkpoint";
    public static final String DOCKERFILE_NATIVE_DISTROLESS = "DockerfileNativeDistroless";
    public static final String DOCKERFILE_NATIVE_STATIC = "DockerfileNativeStatic";
    public static final String DOCKERFILE_NATIVE_ORACLE_CLOUD = "DockerfileNativeOracleCloud";
    private final ExecutorService executorService;

    @Inject
    public DockerfileMojo(MavenProject mavenProject, DockerService dockerService, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, ExecutorService executorService, MavenSession mavenSession, MojoExecution mojoExecution) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService, mavenSession, mojoExecution);
        this.executorService = executorService;
    }

    public void execute() throws MojoExecutionException {
        MicronautRuntime runtime = MicronautRuntime.valueOf((String)this.micronautRuntime.toUpperCase());
        Packaging packaging = Packaging.of(this.mavenProject.getPackaging());
        try {
            this.copyDependencies();
            Optional<File> dockerfile = switch (packaging) {
                case Packaging.DOCKER_NATIVE -> this.buildDockerfileNative(runtime);
                case Packaging.DOCKER -> this.buildDockerfile(runtime);
                case Packaging.DOCKER_CRAC -> this.buildCracDockerfile(runtime);
                default -> throw new MojoExecutionException("Packaging is set to [" + packaging + "]. To generate a Dockerfile, set the packaging to either [" + Packaging.DOCKER.id() + "] or [" + Packaging.DOCKER_NATIVE.id() + "]");
            };
            dockerfile.ifPresent(file -> this.getLog().info((CharSequence)("Dockerfile written to: " + file.getAbsolutePath())));
        }
        catch (IOException | MavenInvocationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Optional<File> buildDockerfile(MicronautRuntime runtime) throws IOException {
        File dockerfile;
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                dockerfile = this.dockerService.loadDockerfileAsResource("DockerfileOracleCloud");
                this.processOracleFunctionDockerfile(dockerfile);
                break;
            }
            case LAMBDA: 
            case DEFAULT: {
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE);
                this.processDockerfile(dockerfile);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + runtime.getBuildStrategy());
            }
        }
        return Optional.ofNullable(dockerfile);
    }

    private Optional<File> buildCracDockerfile(MicronautRuntime runtime) throws IOException, MojoExecutionException {
        File dockerfile;
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                throw new MojoExecutionException("Oracle Functions are currently unsupported");
            }
            case LAMBDA: {
                throw new MojoExecutionException("Lambda Functions are currently unsupported");
            }
            case DEFAULT: {
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE_CRAC_CHECKPOINT, DOCKERFILE_CRAC_CHECKPOINT_FILE);
                this.processDockerfile(dockerfile);
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE_CRAC);
                this.processDockerfile(dockerfile);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + runtime.getBuildStrategy());
            }
        }
        return Optional.ofNullable(dockerfile);
    }

    private void processOracleFunctionDockerfile(File dockerfile) throws IOException {
        if (dockerfile != null) {
            List<String> allLines = Files.readAllLines(dockerfile.toPath());
            String projectFnVersion = JibMicronautExtension.determineProjectFnVersion((String)System.getProperty("java.version"));
            allLines.add(0, allLines.remove(0) + projectFnVersion);
            String entrypoint = JibMicronautExtension.buildProjectFnEntrypoint().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            allLines.add("ENTRYPOINT [" + entrypoint + "]");
            Files.write(dockerfile.toPath(), allLines, new OpenOption[0]);
        }
    }

    private Optional<File> buildDockerfileNative(MicronautRuntime runtime) throws IOException, MavenInvocationException {
        this.getLog().info((CharSequence)"Generating GraalVM args file");
        this.executorService.invokeGoal("org.graalvm.buildtools:native-maven-plugin", "write-args-file");
        File dockerfile = switch (runtime.getBuildStrategy()) {
            case DockerBuildStrategy.LAMBDA -> this.dockerService.loadDockerfileAsResource(DOCKERFILE_AWS_CUSTOM_RUNTIME);
            case DockerBuildStrategy.ORACLE_FUNCTION -> this.dockerService.loadDockerfileAsResource(DOCKERFILE_NATIVE_ORACLE_CLOUD);
            case DockerBuildStrategy.DEFAULT -> {
                String dockerfileName = DOCKERFILE_NATIVE;
                if (Boolean.TRUE.equals(this.staticNativeImage)) {
                    this.getLog().info((CharSequence)"Generating a static native image");
                    dockerfileName = DOCKERFILE_NATIVE_STATIC;
                } else if (this.baseImageRun.contains("distroless")) {
                    this.getLog().info((CharSequence)"Generating a mostly static native image");
                    dockerfileName = DOCKERFILE_NATIVE_DISTROLESS;
                }
                yield this.dockerService.loadDockerfileAsResource(dockerfileName);
            }
            default -> throw new IllegalStateException("Unexpected value: " + runtime.getBuildStrategy());
        };
        this.processDockerfile(dockerfile);
        return Optional.ofNullable(dockerfile);
    }

    private void processDockerfile(File dockerfile) throws IOException {
        if (dockerfile != null) {
            List<String> allLines = Files.readAllLines(dockerfile.toPath());
            ArrayList<String> result = new ArrayList<String>();
            for (String line : allLines) {
                if (line.startsWith("ARG")) continue;
                if (line.contains("BASE_IMAGE_RUN")) {
                    result.add(line.replace("${BASE_IMAGE_RUN}", this.baseImageRun));
                    continue;
                }
                if (line.contains("BASE_IMAGE")) {
                    result.add(line.replace("${BASE_IMAGE}", this.getFrom()));
                    continue;
                }
                if (line.contains("EXTRA_CMD")) {
                    if (this.baseImageRun.contains("alpine-glibc")) {
                        result.add("RUN apk update && apk add libstdc++");
                        continue;
                    }
                    result.add("");
                    continue;
                }
                if (line.contains("GRAALVM_") || line.contains("CLASS_NAME")) {
                    result.add(line.replace("${GRAALVM_JVM_VERSION}", this.graalVmJvmVersion()).replace("${GRAALVM_ARCH}", this.graalVmArch()).replace("${CLASS_NAME}", this.mainClass));
                    continue;
                }
                if (line.contains("PORT")) {
                    result.add(line.replace("${PORT}", this.getPort()));
                    continue;
                }
                result.add(line);
            }
            String argsFile = this.mavenProject.getProperties().getProperty("graalvm.native-image.args-file");
            if (argsFile == null) {
                Path targetPath = Paths.get(this.mavenProject.getBuild().getDirectory(), new String[0]);
                try (Stream<Path> listStream = Files.list(targetPath);){
                    Path argsFilePath = listStream.map(path -> path.getFileName().toString()).filter(f -> f.startsWith("native-image") && f.endsWith("args")).map(targetPath::resolve).findFirst().orElse(null);
                    if (argsFilePath != null) {
                        argsFile = argsFilePath.toAbsolutePath().toString();
                    }
                }
            }
            if (argsFile != null) {
                List<String> allNativeImageBuildArgs = MojoUtils.computeNativeImageArgs(this.nativeImageBuildArgs, this.baseImageRun, argsFile);
                this.getLog().info((CharSequence)("GraalVM native image build args: " + allNativeImageBuildArgs));
            }
            if (this.appArguments != null && !this.appArguments.isEmpty()) {
                this.getLog().info((CharSequence)("Using application arguments: " + this.appArguments));
                result.add(this.getCmd());
            }
            Files.write(dockerfile.toPath(), result, new OpenOption[0]);
        }
    }
}

