/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

public final class MojoUtils {
    private static final String JAVA = "java";

    private MojoUtils() {
    }

    public static String findJavaExecutable(ToolchainManager toolchainManager, MavenSession mavenSession) {
        String executable;
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", mavenSession);
        if (toolchain != null) {
            executable = toolchain.findTool(JAVA);
        } else {
            File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
            executable = Os.isFamily((String)"unix") ? new File(javaBinariesDir, JAVA).getAbsolutePath() : (Os.isFamily((String)"windows") ? new File(javaBinariesDir, "java.exe").getAbsolutePath() : JAVA);
        }
        return executable;
    }

    public static List<String> computeNativeImageArgs(List<String> nativeImageBuildArgs, String baseImageRun, String argsFile) throws IOException {
        List<String> args;
        Path argsFilePath;
        ArrayList<String> allNativeImageBuildArgs = new ArrayList<String>();
        if (nativeImageBuildArgs != null && !nativeImageBuildArgs.isEmpty()) {
            allNativeImageBuildArgs.addAll(nativeImageBuildArgs);
        }
        if (baseImageRun.contains("distroless") && !allNativeImageBuildArgs.contains("-H:+StaticExecutableWithDynamicLibC")) {
            allNativeImageBuildArgs.add("-H:+StaticExecutableWithDynamicLibC");
        }
        if (Files.exists(argsFilePath = Paths.get(argsFile, new String[0]), new LinkOption[0])) {
            args = Files.readAllLines(argsFilePath);
            if (args.contains("-cp")) {
                int cpPosition = args.indexOf("-cp");
                args.remove(cpPosition);
                args.remove(cpPosition);
            }
        } else {
            throw new IOException("Unable to find args file: " + argsFilePath);
        }
        List<String> newArgs = args.stream().filter(arg -> !arg.startsWith("-H:Name")).filter(arg -> !arg.startsWith("-H:Class")).filter(arg -> !arg.startsWith("-H:Path")).filter(arg -> !arg.startsWith("-H:ConfigurationFileDirectories")).map(arg -> {
            if (arg.startsWith("\\Q") && arg.endsWith("\\E")) {
                int lastIndexOfSlash = arg.contains("/") ? arg.lastIndexOf("/") : arg.lastIndexOf("\\");
                return "\\Q/home/app/libs" + arg.substring(lastIndexOfSlash);
            }
            return arg;
        }).toList();
        allNativeImageBuildArgs.addAll(newArgs);
        return allNativeImageBuildArgs;
    }
}

