/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.common.io.FileWriteMode;
import io.micronaut.core.util.StringUtils;
import io.micronaut.maven.AbstractDockerMojo;
import io.micronaut.maven.MojoUtils;
import io.micronaut.maven.core.MicronautRuntime;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.graalvm.buildtools.utils.NativeImageUtils;

@Mojo(name="docker-native", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerNativeMojo
extends AbstractDockerMojo {
    public static final String DOCKER_NATIVE_PACKAGING = "docker-native";
    public static final String MICRONAUT_PARENT = "io.micronaut.platform:micronaut-parent";
    public static final String MICRONAUT_VERSION = "micronaut.version";
    public static final String ARGS_FILE_PROPERTY_NAME = "graalvm.native-image.args-file";

    @Inject
    public DockerNativeMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService, MavenSession mavenSession, MojoExecution mojoExecution) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService, mavenSession, mojoExecution);
    }

    public void execute() throws MojoExecutionException {
        this.checkJavaVersion();
        this.checkGraalVm();
        try {
            this.copyDependencies();
            MicronautRuntime runtime = MicronautRuntime.valueOf((String)this.micronautRuntime.toUpperCase());
            switch (runtime.getBuildStrategy()) {
                case LAMBDA: {
                    this.buildDockerNativeLambda();
                    break;
                }
                case ORACLE_FUNCTION: {
                    this.buildOracleCloud();
                    break;
                }
                case DEFAULT: {
                    this.buildDockerNative();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + runtime.getBuildStrategy());
                }
            }
        }
        catch (InvalidImageReferenceException iire) {
            String message = "Invalid image reference " + iire.getInvalidReference() + ", perhaps you should check that the reference is formatted correctly according to https://docs.docker.com/engine/reference/commandline/tag/#extended-description\nFor example, slash-separated name components cannot have uppercase letters";
            throw new MojoExecutionException(message);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkGraalVm() throws MojoExecutionException {
        String micronautVersion = this.mavenProject.getProperties().getProperty(MICRONAUT_VERSION);
        if (this.mavenProject.hasParent()) {
            String ga = this.mavenProject.getParent().getGroupId() + ":" + this.mavenProject.getParent().getArtifactId();
            if (MICRONAUT_PARENT.equals(ga)) {
                String micronautParentVersion = this.mavenProject.getModel().getParent().getVersion();
                if (micronautVersion.equals(micronautParentVersion)) {
                    if (((List)this.mavenProject.getInjectedProfileIds().get("io.micronaut.platform:micronaut-parent:" + micronautParentVersion)).contains("graalvm")) return;
                    String javaVendor = System.getProperty("java.vendor", "");
                    if (!javaVendor.toLowerCase().contains("graalvm")) throw new MojoExecutionException("The [graalvm] profile was not activated automatically because you are not using a GraalVM JDK. Activate the profile manually (-Pgraalvm) and try again");
                    throw new MojoExecutionException("The [graalvm] profile was not activated automatically because the native-image component is not installed (or not found in your path). Either activate the profile manually (-Pgraalvm) or install the native-image component (gu install native-image), and try again");
                }
                String message = String.format("The %s version (%s) differs from the %s property (%s). Please, make sure both refer to the same version", MICRONAUT_PARENT, micronautParentVersion, MICRONAUT_VERSION, micronautVersion);
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)"The parent POM of this project is not set to io.micronaut.platform:micronaut-parent");
            return;
        } else {
            this.getLog().warn((CharSequence)"This project has no parent POM defined. To avoid build problems, please set the parent to io.micronaut.platform:micronaut-parent");
        }
    }

    private void checkJavaVersion() throws MojoExecutionException {
        if (this.javaVersion().getMajorVersion() > 17) {
            throw new MojoExecutionException("To build native images you must set the Java target byte code level to Java 17 or below");
        }
    }

    private void buildDockerNativeLambda() throws IOException {
        HashMap<String, String> buildImageCmdArguments = new HashMap<String, String>();
        this.getLog().info((CharSequence)("Using GRAALVM_JVM_VERSION: " + this.graalVmJvmVersion()));
        this.getLog().info((CharSequence)("Using GRAALVM_ARCH: " + this.graalVmArch()));
        this.getLog().info((CharSequence)("Using CLASS_NAME: " + this.mainClass));
        BuildImageCmd buildImageCmd = this.addNativeImageBuildArgs(buildImageCmdArguments, () -> {
            try {
                return this.dockerService.buildImageCmd("DockerfileAwsCustomRuntime").withBuildArg("GRAALVM_VERSION", this.graalVmVersion()).withBuildArg("GRAALVM_JVM_VERSION", this.graalVmJvmVersion()).withBuildArg("GRAALVM_ARCH", this.graalVmArch());
            }
            catch (IOException e) {
                throw new DockerClientException(e.getMessage(), (Throwable)e);
            }
        });
        buildImageCmd.withBuildArg("CLASS_NAME", this.mainClass);
        String imageId = this.dockerService.buildImage(buildImageCmd);
        File functionZip = this.dockerService.copyFromContainer(imageId, "/function/function.zip");
        this.getLog().info((CharSequence)("AWS Lambda Custom Runtime ZIP: " + functionZip.getPath()));
    }

    private void buildDockerNative() throws IOException, InvalidImageReferenceException {
        String dockerfileName = "DockerfileNative";
        if (Boolean.TRUE.equals(this.staticNativeImage)) {
            this.getLog().info((CharSequence)"Generating a static native image");
            dockerfileName = "DockerfileNativeStatic";
        } else if (this.baseImageRun.contains("distroless")) {
            this.getLog().info((CharSequence)"Generating a mostly static native image");
            dockerfileName = "DockerfileNativeDistroless";
        }
        this.buildDockerfile(dockerfileName, true);
    }

    private void buildOracleCloud() throws IOException, InvalidImageReferenceException {
        this.buildDockerfile("DockerfileNativeOracleCloud", false);
    }

    private void buildDockerfile(String dockerfileName, boolean passClassName) throws IOException, InvalidImageReferenceException {
        Set<String> tags = this.getTags();
        for (String tag : tags) {
            ImageReference.parse((String)tag);
        }
        String from = this.getFrom();
        String port = this.getPort();
        this.getLog().info((CharSequence)("Exposing port: " + port));
        File dockerfile = this.dockerService.loadDockerfileAsResource(dockerfileName);
        if (this.appArguments != null && !this.appArguments.isEmpty()) {
            this.getLog().info((CharSequence)("Using application arguments: " + this.appArguments));
            com.google.common.io.Files.asCharSink((File)dockerfile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)(System.lineSeparator() + this.getCmd()));
        }
        HashMap<String, String> buildImageCmdArguments = new HashMap<String, String>();
        this.getLog().info((CharSequence)("Using BASE_IMAGE: " + from));
        if (StringUtils.isNotEmpty((CharSequence)this.baseImageRun) && Boolean.FALSE.equals(this.staticNativeImage)) {
            buildImageCmdArguments.put("BASE_IMAGE_RUN", this.baseImageRun);
        }
        if (this.baseImageRun.contains("alpine-glibc")) {
            buildImageCmdArguments.put("EXTRA_CMD", "apk update && apk add libstdc++");
        }
        if (passClassName) {
            buildImageCmdArguments.put("CLASS_NAME", this.mainClass);
        }
        BuildImageCmd buildImageCmd = this.addNativeImageBuildArgs(buildImageCmdArguments, () -> this.dockerService.buildImageCmd().withDockerfile(dockerfile).withTags(this.getTags()).withBuildArg("BASE_IMAGE", from).withBuildArg("PORT", port));
        this.dockerService.buildImage(buildImageCmd);
    }

    private BuildImageCmd addNativeImageBuildArgs(Map<String, String> buildImageCmdArguments, Supplier<BuildImageCmd> buildImageCmdSupplier) throws IOException {
        String argsFile = this.mavenProject.getProperties().getProperty(ARGS_FILE_PROPERTY_NAME);
        List<String> allNativeImageBuildArgs = MojoUtils.computeNativeImageArgs(this.nativeImageBuildArgs, this.baseImageRun, argsFile);
        allNativeImageBuildArgs.remove(this.mainClass);
        this.getLog().info((CharSequence)("GraalVM native image build args: " + allNativeImageBuildArgs));
        List conversionResult = NativeImageUtils.convertToArgsFile(allNativeImageBuildArgs, (Path)Paths.get(this.mavenProject.getBuild().getDirectory(), new String[0]));
        if (conversionResult.size() == 1) {
            Files.delete(Paths.get(argsFile, new String[0]));
            BuildImageCmd buildImageCmd = buildImageCmdSupplier.get();
            for (Map.Entry<String, String> buildArg : buildImageCmdArguments.entrySet()) {
                String key = buildArg.getKey();
                String value = buildArg.getValue();
                this.getLog().info((CharSequence)("Using " + key + ": " + value));
                buildImageCmd.withBuildArg(key, value);
            }
            this.getNetworkMode().ifPresent(arg_0 -> ((BuildImageCmd)buildImageCmd).withNetworkMode(arg_0));
            return buildImageCmd;
        }
        throw new IOException("Unable to convert native image build args to args file");
    }
}

