/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

public final class MojoUtils {
    private static final String JAVA = "java";

    private MojoUtils() {
    }

    public static String findJavaExecutable(ToolchainManager toolchainManager, MavenSession mavenSession) {
        String executable;
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", mavenSession);
        if (toolchain != null) {
            executable = toolchain.findTool(JAVA);
        } else {
            File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
            executable = Os.isFamily((String)"unix") ? new File(javaBinariesDir, JAVA).getAbsolutePath() : (Os.isFamily((String)"windows") ? new File(javaBinariesDir, "java.exe").getAbsolutePath() : JAVA);
        }
        return executable;
    }

    public static List<String> computeNativeImageArgs(List<String> nativeImageBuildArgs, String baseImageRun, String argsFile) {
        ArrayList<String> allNativeImageBuildArgs = new ArrayList<String>();
        if (nativeImageBuildArgs != null && !nativeImageBuildArgs.isEmpty()) {
            allNativeImageBuildArgs.addAll(nativeImageBuildArgs);
        }
        if (baseImageRun.contains("distroless") && !allNativeImageBuildArgs.contains("-H:+StaticExecutableWithDynamicLibC")) {
            allNativeImageBuildArgs.add("-H:+StaticExecutableWithDynamicLibC");
        }
        List<String> argsFileContent = MojoUtils.parseNativeImageArgsFile(argsFile).toList();
        allNativeImageBuildArgs.addAll(argsFileContent);
        return allNativeImageBuildArgs;
    }

    private static Stream<String> parseNativeImageArgsFile(String argsFile) {
        Path argsFilePath = Paths.get(argsFile, new String[0]);
        if (Files.exists(argsFilePath, new LinkOption[0])) {
            List<String> args;
            try {
                args = Files.readAllLines(argsFilePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read the args file: " + argsFilePath, e);
            }
            if (args.contains("-cp")) {
                int cpPosition = args.indexOf("-cp");
                args.remove(cpPosition);
                args.remove(cpPosition);
            }
            return args.stream().filter(arg -> !arg.startsWith("-H:Name")).filter(arg -> !arg.startsWith("-H:Class")).filter(arg -> !arg.startsWith("-H:Path")).filter(arg -> !arg.startsWith("-H:ConfigurationFileDirectories")).flatMap(arg -> {
                if (arg.startsWith("@")) {
                    String fileName = arg.substring(1);
                    return MojoUtils.parseNativeImageArgsFile(fileName);
                }
                if (arg.startsWith("\\Q") && arg.endsWith("\\E")) {
                    int lastIndexOfSlash = arg.lastIndexOf(File.separator, arg.length() - 3);
                    return Stream.of("\\Q/home/app/libs/" + arg.substring(lastIndexOfSlash + 1));
                }
                return Stream.of(arg);
            });
        }
        throw new RuntimeException("Unable to find args file: " + argsFilePath);
    }
}

