/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import io.micronaut.maven.MojoUtils;
import io.micronaut.maven.services.CompilerService;
import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.services.ExecutorService;
import io.micronaut.maven.testresources.AbstractTestResourcesMojo;
import io.micronaut.maven.testresources.TestResourcesHelper;
import io.micronaut.testresources.buildtools.ServerSettings;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends AbstractTestResourcesMojo {
    public static final String MN_APP_ARGS = "mn.appArgs";
    public static final String EXEC_MAIN_CLASS = "${exec.mainClass}";
    public static final String RESOURCES_DIR = "src/main/resources";
    public static final String THIS_PLUGIN = "io.micronaut.maven:micronaut-maven-plugin";
    private static final int LAST_COMPILATION_THRESHOLD = 500;
    private static final List<String> DEFAULT_EXCLUDES = new ArrayList<String>();
    private final MavenSession mavenSession;
    private final ProjectBuilder projectBuilder;
    private final ToolchainManager toolchainManager;
    private final String javaExecutable;
    private final DependencyResolutionService dependencyResolutionService;
    private final CompilerService compilerService;
    private final ExecutorService executorService;
    private final File targetDirectory;
    @Parameter(defaultValue="${exec.mainClass}", required=true)
    private String mainClass;
    @Parameter(property="mn.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="mn.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    @Parameter(property="mn.debug.port", defaultValue="5005")
    private int debugPort;
    @Parameter(property="mn.debug.host", defaultValue="127.0.0.1")
    private String debugHost;
    @Parameter
    private List<FileSet> watches;
    @Parameter(property="mn.jvmArgs")
    private String jvmArguments;
    @Parameter(property="mn.appArgs")
    private String appArguments;
    @Parameter(property="mn.watch", defaultValue="true")
    private boolean watchForChanges;
    @Parameter(property="micronaut.aot.enabled", defaultValue="false")
    private boolean aotEnabled;
    private MavenProject runnableProject;
    private DirectoryWatcher directoryWatcher;
    private Process process;
    private String classpath;
    private int classpathHash;
    private long lastCompilation;
    private List<Path> sourceDirectories;
    private TestResourcesHelper testResourcesHelper;

    @Inject
    public RunMojo(MavenSession mavenSession, BuildPluginManager pluginManager, ProjectBuilder projectBuilder, ToolchainManager toolchainManager, CompilerService compilerService, ExecutorService executorService, DependencyResolutionService dependencyResolutionService) {
        this.runnableProject = compilerService.findRunnableProject();
        this.mavenSession = mavenSession;
        this.projectBuilder = projectBuilder;
        this.toolchainManager = toolchainManager;
        this.compilerService = compilerService;
        this.executorService = executorService;
        this.javaExecutable = MojoUtils.findJavaExecutable(toolchainManager, mavenSession);
        this.dependencyResolutionService = dependencyResolutionService;
        this.targetDirectory = new File(this.runnableProject.getBuild().getDirectory());
    }

    public void execute() throws MojoExecutionException {
        this.testResourcesHelper = new TestResourcesHelper(this.testResourcesEnabled, this.keepAlive, this.shared, this.buildDirectory, this.explicitPort, this.clientTimeout, this.runnableProject, this.mavenSession, this.dependencyResolutionService, this.toolchainManager, this.testResourcesVersion, this.classpathInference, this.testResourcesDependencies, this.sharedServerNamespace);
        this.resolveDependencies();
        this.sourceDirectories = this.compilerService.resolveSourceDirectories();
        try {
            this.maybeStartTestResourcesServer();
            this.runApplication();
            Thread shutdownHook = new Thread(this::killProcess);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            if (this.process != null && this.process.isAlive()) {
                if (this.watchForChanges) {
                    ArrayList<Path> pathsToWatch = new ArrayList<Path>(this.sourceDirectories);
                    for (MavenProject project : this.mavenSession.getProjects()) {
                        Path baseDir = project.getBasedir().toPath();
                        pathsToWatch.add(baseDir);
                        if (!Files.exists(baseDir.resolve(RESOURCES_DIR), new LinkOption[0])) continue;
                        pathsToWatch.add(baseDir.resolve(RESOURCES_DIR));
                    }
                    if (this.watches != null && !this.watches.isEmpty()) {
                        for (FileSet fs : this.watches) {
                            File directory = new File(fs.getDirectory());
                            if (directory.exists()) {
                                pathsToWatch.add(directory.toPath());
                                if (fs.getIncludes() != null && !fs.getIncludes().isEmpty() || fs.getExcludes() != null && !fs.getExcludes().isEmpty()) continue;
                                fs.addInclude("**/*");
                                continue;
                            }
                            if (!this.getLog().isWarnEnabled()) continue;
                            this.getLog().warn((CharSequence)("The specified directory to watch doesn't exist: " + directory.getPath()));
                        }
                    }
                    this.directoryWatcher = DirectoryWatcher.builder().paths(pathsToWatch).listener(this::handleEvent).build();
                    Path projectRootDirectory = this.mavenSession.getTopLevelProject().getBasedir().toPath();
                    List<Path> pathList = pathsToWatch.stream().map(other -> projectRootDirectory.getParent().relativize((Path)other)).sorted().toList();
                    this.getLog().info((CharSequence)("\ud83d\udc40 Watching for changes in " + pathList));
                    this.directoryWatcher.watch();
                } else if (this.process != null && this.process.isAlive()) {
                    this.process.waitFor();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Exception while watching for changes", (Throwable)e);
            }
            throw new MojoExecutionException("Exception while watching for changes", e);
        }
        finally {
            this.killProcess();
            this.cleanup();
        }
    }

    private void handleEvent(DirectoryChangeEvent event) {
        Path path = event.path();
        Path parent = path.getParent();
        List<Path> projectRoots = this.mavenSession.getProjects().stream().map(MavenProject::getBasedir).map(File::toPath).toList();
        Path projectRootDirectory = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        if (this.matches(path)) {
            boolean compiledOk;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("\ud83d\udcdd Detected change in %s. Recompiling/restarting...", projectRootDirectory.relativize(path)));
            }
            if (compiledOk = this.compileProject()) {
                try {
                    this.runApplication();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Unable to run application: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private boolean matches(Path path) {
        if (this.isDefaultExcluded(path) || Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) || !Files.isReadable(path) || this.hasBeenCompiledRecently()) {
            return false;
        }
        List<Path> values = this.sourceDirectories;
        ArrayList<Path> pathsToCheck = new ArrayList<Path>(values.size() + 1);
        pathsToCheck.addAll(values);
        for (MavenProject project : this.mavenSession.getProjects()) {
            Path baseDir = project.getBasedir().toPath();
            pathsToCheck.add(baseDir);
            if (!Files.exists(baseDir.resolve(RESOURCES_DIR), new LinkOption[0])) continue;
            pathsToCheck.add(baseDir.resolve(RESOURCES_DIR));
        }
        boolean matches = pathsToCheck.stream().anyMatch(path.getParent()::startsWith);
        Path projectRootDirectory = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        String relativePath = projectRootDirectory.relativize(path).toString();
        if (this.getLog().isDebugEnabled()) {
            String belongs = matches ? "belongs" : "does not belong";
            this.getLog().debug((CharSequence)("Path [" + relativePath + "] " + belongs + " to a source directory"));
        }
        if (this.watches != null && !this.watches.isEmpty()) {
            File directory;
            if (!matches) {
                for (FileSet fileSet : this.watches) {
                    if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                        for (String includePattern : fileSet.getIncludes()) {
                            if (!AbstractScanner.match((String)includePattern, (String)path.toString()) && !new File(directory, includePattern).toPath().toAbsolutePath().equals(path)) continue;
                            matches = true;
                            if (!this.getLog().isDebugEnabled()) break;
                            this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the include pattern [" + includePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                            break;
                        }
                    }
                    if (!matches) continue;
                    break;
                }
            }
            if (matches) {
                for (FileSet fileSet : this.watches) {
                    if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                        for (String excludePattern : fileSet.getExcludes()) {
                            if (!AbstractScanner.match((String)excludePattern, (String)path.toString()) && !new File(directory, excludePattern).toPath().toAbsolutePath().equals(path)) continue;
                            matches = false;
                            if (!this.getLog().isDebugEnabled()) break;
                            this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the exclude pattern [" + excludePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                            break;
                        }
                    }
                    if (matches) continue;
                    break;
                }
            }
        }
        return matches;
    }

    private boolean isDefaultExcluded(Path path) {
        boolean excludeTargetDirectory = true;
        if (this.watches != null && !this.watches.isEmpty()) {
            for (FileSet fileSet : this.watches) {
                if (!fileSet.getDirectory().equals(this.targetDirectory.getName())) continue;
                excludeTargetDirectory = false;
            }
        }
        return excludeTargetDirectory && path.startsWith(this.targetDirectory.getAbsolutePath()) || DEFAULT_EXCLUDES.stream().anyMatch(excludePattern -> AbstractScanner.match((String)excludePattern, (String)path.toString()));
    }

    private boolean hasBeenCompiledRecently() {
        return System.currentTimeMillis() - this.lastCompilation < 500L;
    }

    private void cleanup() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Cleaning up");
        }
        try {
            this.directoryWatcher.close();
            this.maybeStopTestResourcesServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean rebuildMavenProject() {
        boolean success;
        block2: {
            success = true;
            try {
                MavenProject project;
                ProjectBuildingRequest projectBuildingRequest = this.mavenSession.getProjectBuildingRequest();
                projectBuildingRequest.setResolveDependencies(true);
                ProjectBuildingResult build = this.projectBuilder.build(this.runnableProject.getArtifact(), projectBuildingRequest);
                this.runnableProject = project = build.getProject();
                this.mavenSession.setCurrentProject(project);
            }
            catch (ProjectBuildingException e) {
                success = false;
                if (!this.getLog().isWarnEnabled()) break block2;
                this.getLog().warn((CharSequence)"Error while trying to build the Maven project model", (Throwable)e);
            }
        }
        return success;
    }

    private boolean resolveDependencies() {
        try {
            List<Dependency> dependencies = this.compilerService.resolveDependencies("provided", "compile", "runtime");
            if (dependencies.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.classpath = this.compilerService.buildClasspath(dependencies);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.classpath != null) {
                this.classpathHash = this.classpath.hashCode();
            }
        }
    }

    private boolean classpathHasChanged() {
        int oldClasspathHash = this.classpathHash;
        this.classpathHash = this.classpath.hashCode();
        return oldClasspathHash != this.classpathHash;
    }

    private void runApplication() throws Exception {
        String[] strings;
        this.runAotIfNeeded();
        String classpathArgument = new File(this.targetDirectory, "classes" + File.pathSeparator).getAbsolutePath() + this.classpath;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.javaExecutable);
        if (this.debug) {
            String suspend = this.debugSuspend ? "y" : "n";
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + this.debugHost + ":" + this.debugPort);
        }
        if (this.testResourcesEnabled) {
            Path testResourcesSettingsDirectory = this.shared ? ServerUtils.getDefaultSharedSettingsPath((String)this.sharedServerNamespace) : AbstractTestResourcesMojo.serverSettingsDirectoryOf(this.targetDirectory.toPath());
            Optional serverSettings = ServerUtils.readServerSettings((Path)testResourcesSettingsDirectory);
            serverSettings.ifPresent(settings -> this.testResourcesHelper.computeSystemProperties((ServerSettings)settings).forEach((k, v) -> args.add("-D" + k + "=" + v)));
        }
        if (this.jvmArguments != null && !this.jvmArguments.isEmpty()) {
            strings = CommandLineUtils.translateCommandline((String)this.jvmArguments);
            args.addAll(Arrays.asList(strings));
        }
        if (!this.mavenSession.getUserProperties().isEmpty()) {
            this.mavenSession.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + k + "=" + v)));
        }
        args.add("-classpath");
        args.add(classpathArgument);
        args.add("-XX:TieredStopAtLevel=1");
        args.add("-Dcom.sun.management.jmxremote");
        args.add(this.mainClass);
        if (this.appArguments != null && !this.appArguments.isEmpty()) {
            strings = CommandLineUtils.translateCommandline((String)this.appArguments);
            args.addAll(Arrays.asList(strings));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Running " + String.join((CharSequence)" ", args)));
        }
        this.killProcess();
        this.process = new ProcessBuilder(args).inheritIO().directory(this.targetDirectory).start();
    }

    private void runAotIfNeeded() {
        if (this.aotEnabled) {
            try {
                this.executorService.executeGoal(THIS_PLUGIN, "aot-analysis");
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)e.getMessage());
            }
        }
    }

    private void maybeStartTestResourcesServer() throws MojoExecutionException {
        this.testResourcesHelper.start();
    }

    private void maybeStopTestResourcesServer() throws MojoExecutionException {
        this.testResourcesHelper.stop();
    }

    private boolean compileProject() {
        Optional<Long> lastCompilationMillis = this.compilerService.compileProject();
        lastCompilationMillis.ifPresent(lc -> {
            this.lastCompilation = lc;
        });
        return lastCompilationMillis.isPresent();
    }

    private void killProcess() {
        if (this.process != null && this.process.isAlive()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Stopping the background process");
            }
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                this.process.destroyForcibly();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        Collections.addAll(DEFAULT_EXCLUDES, AbstractScanner.DEFAULTEXCLUDES);
        Collections.addAll(DEFAULT_EXCLUDES, "**/.idea/**", "**/src/test/**");
    }
}

