/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import io.micronaut.maven.services.ExecutorService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Singleton
public class CompilerService {
    public static final String MAVEN_JAR_PLUGIN = "org.apache.maven.plugins:maven-jar-plugin";
    private static final String COMPILE_GOAL = "compile";
    private static final String JAVA = "java";
    private static final String GROOVY = "groovy";
    private static final String KOTLIN = "kotlin";
    private final Log log;
    private final MavenProject runnableProject;
    private final MavenSession mavenSession;
    private final ExecutorService executorService;
    private final ProjectDependenciesResolver resolver;

    @Inject
    public CompilerService(MavenSession mavenSession, ExecutorService executorService, ProjectDependenciesResolver resolver) {
        this.mavenSession = mavenSession;
        this.runnableProject = this.findRunnableProject();
        this.resolver = resolver;
        this.log = new SystemStreamLog();
        this.executorService = executorService;
    }

    public Optional<Long> compileProject() {
        Long lastCompilation;
        block3: {
            lastCompilation = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Compiling the project");
            }
            try {
                this.executorService.invokeGoals(COMPILE_GOAL);
                lastCompilation = System.currentTimeMillis();
            }
            catch (MavenInvocationException e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((CharSequence)"Error while compiling the project: ", (Throwable)e);
            }
        }
        return Optional.ofNullable(lastCompilation);
    }

    public List<Path> resolveSourceDirectories() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Resolving source directories...");
        }
        return this.mavenSession.getProjects().stream().map(this::resolveSourceDirectories).flatMap(Collection::stream).toList();
    }

    private Set<Path> resolveSourceDirectories(MavenProject project) {
        HashSet<Path> sourceDirectoriesToResolve = new HashSet<Path>(3);
        for (String lang : Arrays.asList(JAVA, GROOVY, KOTLIN)) {
            Path sourceDir = project.getBasedir().toPath().resolve("src/main/" + lang);
            if (!Files.exists(sourceDir, new LinkOption[0])) continue;
            sourceDirectoriesToResolve.add(sourceDir);
        }
        sourceDirectoriesToResolve.addAll(project.getCompileSourceRoots().stream().map(File::new).map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toSet()));
        return sourceDirectoriesToResolve;
    }

    public MavenProject findRunnableProject() {
        return this.mavenSession.getProjects().stream().filter(this::hasMicronautMavenPlugin).findFirst().orElseThrow(() -> new IllegalStateException("There are no projects with the Micronaut Maven plugin defined"));
    }

    private boolean hasMicronautMavenPlugin(MavenProject project) {
        return this.hasPlugin(project, "io.micronaut.maven:micronaut-maven-plugin");
    }

    private boolean hasPlugin(MavenProject project, String pluginKey) {
        String[] parts = pluginKey.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        return project.getBuildPlugins().stream().anyMatch(p -> p.getGroupId().equals(groupId) && p.getArtifactId().equals(artifactId));
    }

    public List<Dependency> resolveDependencies(String ... scopes) {
        try {
            DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])scopes);
            RepositorySystemSession session = this.mavenSession.getRepositorySession();
            DefaultDependencyResolutionRequest dependencyResolutionRequest = new DefaultDependencyResolutionRequest(this.runnableProject, session);
            dependencyResolutionRequest.setResolutionFilter(filter);
            DependencyResolutionResult result = this.resolver.resolve((DependencyResolutionRequest)dependencyResolutionRequest);
            return result.getDependencies();
        }
        catch (DependencyResolutionException e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((CharSequence)"Error while trying to resolve dependencies for the current project", (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    public String buildClasspath(List<Dependency> dependencies) {
        Comparator<Dependency> byGroupId = Comparator.comparing(d -> d.getArtifact().getGroupId());
        Comparator<Dependency> byArtifactId = Comparator.comparing(d -> d.getArtifact().getArtifactId());
        return dependencies.stream().sorted(byGroupId.thenComparing(byArtifactId)).map(dependency -> dependency.getArtifact().getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
    }

    public InvocationResult packageProject() throws MavenInvocationException {
        return this.executorService.invokeGoal(MAVEN_JAR_PLUGIN, "jar");
    }
}

