/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import io.micronaut.maven.MojoUtils;
import io.micronaut.maven.services.CompilerService;
import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.services.ExecutorService;
import io.micronaut.maven.testresources.AbstractTestResourcesMojo;
import io.micronaut.maven.testresources.TestResourcesHelper;
import io.micronaut.testresources.buildtools.ServerSettings;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends AbstractTestResourcesMojo {
    public static final String MN_APP_ARGS = "mn.appArgs";
    public static final String EXEC_MAIN_CLASS = "${exec.mainClass}";
    public static final String RESOURCES_DIR = "src/main/resources";
    public static final String THIS_PLUGIN = "io.micronaut.maven:micronaut-maven-plugin";
    private static final List<String> RELEVANT_SRC_DIRS = List.of("resources", "java", "kotlin", "groovy");
    private static final int LAST_COMPILATION_THRESHOLD = 500;
    private static final List<String> DEFAULT_EXCLUDES = new ArrayList<String>();
    private final MavenSession mavenSession;
    private final ProjectBuilder projectBuilder;
    private final ToolchainManager toolchainManager;
    private final String javaExecutable;
    private final DependencyResolutionService dependencyResolutionService;
    private final CompilerService compilerService;
    private final ExecutorService executorService;
    private File targetDirectory;
    @Parameter(defaultValue="${exec.mainClass}")
    private String mainClass;
    @Parameter(property="mn.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="mn.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    @Parameter(property="mn.debug.port", defaultValue="5005")
    private int debugPort;
    @Parameter(property="mn.debug.host", defaultValue="127.0.0.1")
    private String debugHost;
    @Parameter
    private List<FileSet> watches;
    @Parameter(property="mn.jvmArgs")
    private String jvmArguments;
    @Parameter(property="mn.appArgs")
    private String appArguments;
    @Parameter(property="mn.watch", defaultValue="true")
    private boolean watchForChanges;
    @Parameter(property="micronaut.aot.enabled", defaultValue="false")
    private boolean aotEnabled;
    private final AtomicBoolean recompileRequested = new AtomicBoolean();
    private final ReentrantLock restartLock = new ReentrantLock();
    private MavenProject runnableProject;
    private DirectoryWatcher directoryWatcher;
    private volatile Process process;
    private String classpath;
    private int classpathHash;
    private long lastCompilation;
    private TestResourcesHelper testResourcesHelper;

    @Inject
    public RunMojo(MavenSession mavenSession, BuildPluginManager pluginManager, ProjectBuilder projectBuilder, ToolchainManager toolchainManager, CompilerService compilerService, ExecutorService executorService, DependencyResolutionService dependencyResolutionService) {
        this.mavenSession = mavenSession;
        this.projectBuilder = projectBuilder;
        this.toolchainManager = toolchainManager;
        this.compilerService = compilerService;
        this.executorService = executorService;
        this.javaExecutable = MojoUtils.findJavaExecutable(toolchainManager, mavenSession);
        this.dependencyResolutionService = dependencyResolutionService;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
        try {
            this.maybeStartTestResourcesServer();
            this.runApplication();
            Thread shutdownHook = new Thread(this::killProcess);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            if (this.process != null && this.process.isAlive()) {
                if (this.watchForChanges) {
                    ArrayList<Path> pathsToWatch = new ArrayList<Path>();
                    for (FileSet fs : this.watches) {
                        Path directory = this.runnableProject.getBasedir().toPath().resolve(fs.getDirectory()).toAbsolutePath();
                        if (!Files.exists(directory, new LinkOption[0])) continue;
                        pathsToWatch.add(directory);
                        if (fs.getIncludes() != null && !fs.getIncludes().isEmpty() || fs.getExcludes() != null && !fs.getExcludes().isEmpty()) continue;
                        fs.addInclude("**/*");
                    }
                    this.directoryWatcher = DirectoryWatcher.builder().paths(pathsToWatch).listener(this::handleEvent).build();
                    Path root = Path.of(".", new String[0]).toAbsolutePath();
                    List<Path> pathList = pathsToWatch.stream().map(root::relativize).filter(s -> !s.toString().isEmpty()).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).sorted().toList();
                    this.getLog().info((CharSequence)("\ud83d\udc40 Watching for changes in " + String.valueOf(pathList)));
                    this.directoryWatcher.watch();
                } else if (this.process != null && this.process.isAlive()) {
                    this.process.waitFor();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Exception while watching for changes", (Throwable)e);
            }
            throw new MojoExecutionException("Exception while watching for changes", e);
        }
        finally {
            this.killProcess();
            this.cleanup();
        }
    }

    protected final void initialize() {
        MavenProject currentProject = this.mavenSession.getCurrentProject();
        if (MojoUtils.hasMicronautMavenPlugin(currentProject)) {
            this.runnableProject = currentProject;
        } else {
            List<MavenProject> projectsWithPlugin = this.mavenSession.getProjects().stream().filter(MojoUtils::hasMicronautMavenPlugin).toList();
            if (projectsWithPlugin.size() == 1) {
                this.runnableProject = projectsWithPlugin.get(0);
                this.log.info((CharSequence)"Running project %s".formatted(this.runnableProject.getArtifactId()));
            } else {
                throw new IllegalStateException("The Micronaut Maven Plugin is declared in the following projects: %s. Please specify the project to run with the -pl option.".formatted(projectsWithPlugin.stream().map(MavenProject::getArtifactId).toList()));
            }
        }
        this.targetDirectory = new File(this.runnableProject.getBuild().getDirectory());
        this.testResourcesHelper = new TestResourcesHelper(this.testResourcesEnabled, this.shared, this.buildDirectory, this.explicitPort, this.clientTimeout, this.serverIdleTimeoutMinutes, this.runnableProject, this.mavenSession, this.dependencyResolutionService, this.toolchainManager, this.testResourcesVersion, this.classpathInference, this.testResourcesDependencies, this.sharedServerNamespace, this.debugServer, false, this.testResourcesSystemProperties);
        this.resolveDependencies();
        if (this.watches == null) {
            this.watches = new ArrayList<FileSet>();
        }
        this.mavenSession.getAllProjects().stream().filter(this::isDependencyOfRunnableProject).map(MavenProject::getBasedir).map(File::toPath).forEach(path -> {
            FileSet fileSet = new FileSet();
            fileSet.setDirectory(path.toString());
            fileSet.addInclude("pom.xml");
            this.watches.add(fileSet);
        });
        this.mavenSession.getAllProjects().stream().filter(this::isDependencyOfRunnableProject).flatMap(p -> {
            Path basedir = p.getBasedir().toPath();
            return RELEVANT_SRC_DIRS.stream().map(dir -> basedir.resolve("src/main/" + dir));
        }).forEach(path -> {
            FileSet fileSet = new FileSet();
            fileSet.setDirectory(path.toString());
            fileSet.addInclude("**/*");
            this.watches.add(fileSet);
        });
        this.compileProject();
    }

    private boolean isDependencyOfRunnableProject(MavenProject mavenProject) {
        return mavenProject.equals((Object)this.runnableProject) || this.runnableProject.getDependencies().stream().anyMatch(d -> d.getGroupId().equals(mavenProject.getGroupId()) && d.getArtifactId().equals(mavenProject.getArtifactId()));
    }

    protected final void setWatches(List<FileSet> watches) {
        this.watches = watches;
    }

    final void handleEvent(DirectoryChangeEvent event) {
        Path path = event.path();
        Path parent = path.getParent();
        Path projectRootDirectory = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        if (this.matches(path)) {
            boolean compiledOk;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("\ud83d\udcdd Detected change in %s. Recompiling/restarting...", projectRootDirectory.relativize(path)));
            }
            if (compiledOk = this.compileProject()) {
                try {
                    this.runApplication();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Unable to run application: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private boolean matches(Path path) {
        File directory;
        if (this.isDefaultExcluded(path) || Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) || !Files.isReadable(path) || this.hasBeenCompiledRecently()) {
            return false;
        }
        Path projectRootDirectory = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        String relativePath = projectRootDirectory.relativize(path).toString();
        boolean matches = false;
        for (FileSet fileSet : this.watches) {
            if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                for (String includePattern : fileSet.getIncludes()) {
                    if (!RunMojo.pathMatches(includePattern, path) && !RunMojo.patternEquals(path, includePattern, directory)) continue;
                    matches = true;
                    if (!this.getLog().isDebugEnabled()) break;
                    this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the include pattern [" + includePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                    break;
                }
            }
            if (!matches) continue;
            break;
        }
        if (matches) {
            for (FileSet fileSet : this.watches) {
                if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                    for (String excludePattern : fileSet.getExcludes()) {
                        if (!RunMojo.pathMatches(excludePattern, path) && !RunMojo.patternEquals(path, excludePattern, directory)) continue;
                        matches = false;
                        if (!this.getLog().isDebugEnabled()) break;
                        this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the exclude pattern [" + excludePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                        break;
                    }
                }
                if (matches) continue;
                break;
            }
        }
        return matches;
    }

    private boolean isDefaultExcluded(Path path) {
        boolean excludeTargetDirectory = true;
        if (this.watches != null && !this.watches.isEmpty()) {
            for (FileSet fileSet : this.watches) {
                if (!fileSet.getDirectory().equals(this.targetDirectory.getName())) continue;
                excludeTargetDirectory = false;
            }
        }
        return excludeTargetDirectory && path.startsWith(this.targetDirectory.getAbsolutePath()) || DEFAULT_EXCLUDES.stream().anyMatch(excludePattern -> RunMojo.pathMatches(excludePattern, path));
    }

    private boolean hasBeenCompiledRecently() {
        return System.currentTimeMillis() - this.lastCompilation < 500L;
    }

    private void cleanup() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Cleaning up");
        }
        try {
            this.directoryWatcher.close();
            this.maybeStopTestResourcesServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean rebuildMavenProject() {
        boolean success;
        block2: {
            success = true;
            try {
                MavenProject project;
                ProjectBuildingRequest projectBuildingRequest = this.mavenSession.getProjectBuildingRequest();
                projectBuildingRequest.setResolveDependencies(true);
                ProjectBuildingResult build = this.projectBuilder.build(this.runnableProject.getArtifact(), projectBuildingRequest);
                this.runnableProject = project = build.getProject();
                this.mavenSession.setCurrentProject(project);
            }
            catch (ProjectBuildingException e) {
                success = false;
                if (!this.getLog().isWarnEnabled()) break block2;
                this.getLog().warn((CharSequence)"Error while trying to build the Maven project model", (Throwable)e);
            }
        }
        return success;
    }

    private boolean resolveDependencies() {
        try {
            List<Dependency> dependencies = this.compilerService.resolveDependencies(this.runnableProject, true, "provided", "compile", "runtime");
            if (dependencies.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.classpath = this.compilerService.buildClasspath(dependencies);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.classpath != null) {
                this.classpathHash = this.classpath.hashCode();
            }
        }
    }

    private boolean classpathHasChanged() {
        int oldClasspathHash = this.classpathHash;
        this.classpathHash = this.classpath.hashCode();
        return oldClasspathHash != this.classpathHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runApplication() throws Exception {
        if (this.restartLock.getQueueLength() >= 1) {
            return;
        }
        this.restartLock.lock();
        try {
            String[] strings;
            this.runAotIfNeeded();
            String reactorClasses = this.mavenSession.getAllProjects().stream().map(MavenProject::getBuild).map(Build::getOutputDirectory).collect(Collectors.joining(File.pathSeparator));
            String classpathArgument = String.join((CharSequence)File.pathSeparator, reactorClasses, this.classpath);
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.javaExecutable);
            if (this.debug) {
                String suspend = this.debugSuspend ? "y" : "n";
                args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + this.debugHost + ":" + this.debugPort);
            }
            if (this.testResourcesEnabled) {
                Path testResourcesSettingsDirectory = this.shared ? ServerUtils.getDefaultSharedSettingsPath((String)this.sharedServerNamespace) : AbstractTestResourcesMojo.serverSettingsDirectoryOf(this.targetDirectory.toPath());
                Optional serverSettings = ServerUtils.readServerSettings((Path)testResourcesSettingsDirectory);
                serverSettings.ifPresent(settings -> this.testResourcesHelper.computeSystemProperties((ServerSettings)settings).forEach((k, v) -> args.add("-D" + k + "=" + v)));
            }
            if (this.jvmArguments != null && !this.jvmArguments.isEmpty()) {
                strings = CommandLineUtils.translateCommandline((String)this.jvmArguments);
                args.addAll(Arrays.asList(strings));
            }
            if (!this.mavenSession.getUserProperties().isEmpty()) {
                this.mavenSession.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + String.valueOf(k) + "=" + String.valueOf(v))));
            }
            if (this.mainClass == null) {
                this.mainClass = this.runnableProject.getProperties().getProperty("exec.mainClass");
            }
            args.add("-classpath");
            args.add(classpathArgument);
            args.add("-XX:TieredStopAtLevel=1");
            args.add("-Dcom.sun.management.jmxremote");
            args.add(this.mainClass);
            if (this.appArguments != null && !this.appArguments.isEmpty()) {
                strings = CommandLineUtils.translateCommandline((String)this.appArguments);
                args.addAll(Arrays.asList(strings));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Running " + String.join((CharSequence)" ", args)));
            }
            this.killProcess();
            this.process = new ProcessBuilder(args).inheritIO().directory(this.targetDirectory).start();
        }
        finally {
            this.restartLock.unlock();
        }
    }

    private void runAotIfNeeded() {
        if (this.aotEnabled) {
            try {
                this.executorService.executeGoal(THIS_PLUGIN, "aot-analysis");
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)e.getMessage());
            }
        }
    }

    private void maybeStartTestResourcesServer() throws MojoExecutionException {
        this.testResourcesHelper.start();
    }

    private void maybeStopTestResourcesServer() throws MojoExecutionException {
        this.testResourcesHelper.stop(false);
    }

    private boolean compileProject() {
        if (this.recompileRequested.get()) {
            return false;
        }
        this.recompileRequested.set(true);
        try {
            boolean bl = this.doCompile();
            return bl;
        }
        finally {
            this.recompileRequested.set(false);
        }
    }

    private boolean doCompile() {
        Optional<Long> lastCompilationMillis = this.compilerService.compileProject();
        lastCompilationMillis.ifPresent(lc -> {
            this.lastCompilation = lc;
        });
        return lastCompilationMillis.isPresent();
    }

    private void killProcess() {
        if (this.process != null && this.process.isAlive()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Stopping the background process");
            }
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                this.process.destroyForcibly();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String normalize(Path path) {
        return path.toString().replace('\\', '/');
    }

    private static boolean pathMatches(String pattern, Path path) {
        return AbstractScanner.match((String)pattern, (String)RunMojo.normalize(path));
    }

    private static boolean patternEquals(Path path, String includePattern, File directory) {
        try {
            String testPath = RunMojo.normalize(directory.toPath().resolve(includePattern).toAbsolutePath());
            return testPath.equals(RunMojo.normalize(path.toAbsolutePath()));
        }
        catch (InvalidPathException ex) {
            return false;
        }
    }

    static {
        Collections.addAll(DEFAULT_EXCLUDES, AbstractScanner.DEFAULTEXCLUDES);
        Collections.addAll(DEFAULT_EXCLUDES, "**/.idea/**", "**/src/test/**");
    }
}

