/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.aot;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.maven.MojoUtils;
import io.micronaut.maven.aot.AbstractMicronautAotMojo;
import io.micronaut.maven.services.CompilerService;
import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.services.ExecutorService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractMicronautAotCliMojo
extends AbstractMicronautAotMojo {
    public static final String EXEC_MAVEN_PLUGIN_GROUP = "org.codehaus.mojo";
    public static final String EXEC_MAVEN_PLUGIN_ARTIFACT = "exec-maven-plugin";
    public static final String EXEC_MAVEN_PLUGIN_VERSION_PROPERTY = "exec-maven-plugin.version";
    public static final String DEFAULT_EXEC_MAVEN_PLUGIN_VERSION = "3.1.0";
    private static final String[] AOT_MODULES = new String[]{"api", "cli", "std-optimizers"};
    @Parameter(property="micronaut.aot.packageName")
    protected String packageName;
    private final ExecutorService executorService;
    private final DependencyResolutionService dependencyResolutionService;
    private final MavenSession mavenSession;
    private final ToolchainManager toolchainManager;
    @Parameter
    private List<Dependency> aotDependencies;
    @Parameter(property="micronaut.aot.jvmArgs")
    private List<String> aotJvmArgs;

    @Inject
    public AbstractMicronautAotCliMojo(CompilerService compilerService, ExecutorService executorService, MavenProject mavenProject, DependencyResolutionService dependencyResolutionService, MavenSession mavenSession, ToolchainManager toolchainManager) {
        super(compilerService, mavenProject);
        this.executorService = executorService;
        this.dependencyResolutionService = dependencyResolutionService;
        this.mavenSession = mavenSession;
        this.toolchainManager = toolchainManager;
    }

    protected abstract List<String> getExtraArgs() throws MojoExecutionException;

    @Override
    protected void doExecute() throws MojoExecutionException, DependencyResolutionException {
        if (StringUtils.isEmpty((String)this.packageName)) {
            throw new MojoExecutionException("micronaut.aot.packageName is not set, and is required if AOT is enabled");
        }
        try {
            this.getLog().info((CharSequence)"Packaging project");
            this.compilerService.compileProject();
            InvocationResult packagingResult = this.compilerService.packageProject();
            if (packagingResult.getExitCode() != 0) {
                this.getLog().error((CharSequence)"Error when packaging the project: ", (Throwable)packagingResult.getExecutionException());
            } else {
                this.executeAot();
            }
        }
        catch (MavenInvocationException e) {
            this.getLog().error((CharSequence)"Error when packaging project", (Throwable)e);
        }
    }

    private void executeAot() throws DependencyResolutionException, MojoExecutionException {
        this.getLog().info((CharSequence)"Executing Micronaut AOT analysis");
        Xpp3Dom config = this.createExecPluginConfig();
        try {
            this.executorService.executeGoal(EXEC_MAVEN_PLUGIN_GROUP, EXEC_MAVEN_PLUGIN_ARTIFACT, this.mavenProject.getProperties().getProperty(EXEC_MAVEN_PLUGIN_VERSION_PROPERTY, DEFAULT_EXEC_MAVEN_PLUGIN_VERSION), "exec", config);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error when executing Micronaut AOT: " + e.getMessage()));
            String commandLine = Arrays.stream(config.getChild("arguments").getChildren()).map(Xpp3Dom::getValue).collect(Collectors.joining(" "));
            this.getLog().error((CharSequence)("Command line was: java " + commandLine));
            throw e;
        }
    }

    private Xpp3Dom createExecPluginConfig() throws DependencyResolutionException, MojoExecutionException {
        List<String> aotClasspath = this.resolveAotClasspath();
        List<String> aotPluginsClasspath = this.resolveAotPluginsClasspath();
        List<String> applicationClasspath = this.resolveApplicationClasspath();
        ArrayList<String> classpath = new ArrayList<String>(aotPluginsClasspath.size() + applicationClasspath.size());
        classpath.addAll(aotClasspath);
        classpath.addAll(aotPluginsClasspath);
        classpath.addAll(applicationClasspath);
        if (!CollectionUtils.isEmpty((Collection)this.aotExclusions)) {
            this.getLog().info((CharSequence)("Using exclusions for the AOT classpath: " + this.aotExclusions.stream().map(v -> v.getGroupId() + ":" + v.getArtifactId()).collect(Collectors.joining(", "))));
            this.getLog().info((CharSequence)("Resulting AOT classpath: " + String.join((CharSequence)", ", classpath)));
        }
        Stream jvmArgs = Optional.ofNullable(this.aotJvmArgs).orElse(List.of()).stream();
        Stream<String> mainArgs = Stream.of("-classpath", String.join((CharSequence)File.pathSeparator, aotClasspath), "io.micronaut.aot.cli.Main", "--classpath=" + String.join((CharSequence)File.pathSeparator, classpath), "--package=" + this.packageName, "--runtime=" + this.runtime);
        MojoExecutor.Element[] runnerArgs = (MojoExecutor.Element[])Stream.concat(Stream.concat(jvmArgs, mainArgs), this.getExtraArgs().stream()).map(arg -> MojoExecutor.element((String)"argument", (String)arg)).toArray(MojoExecutor.Element[]::new);
        String javaExecutable = MojoUtils.findJavaExecutable(this.toolchainManager, this.mavenSession);
        return MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"executable", (String)javaExecutable), MojoExecutor.element((String)"arguments", (MojoExecutor.Element[])runnerArgs)});
    }

    private List<String> resolveApplicationClasspath() {
        String projectJar = new File(this.mavenProject.getBuild().getDirectory(), this.mavenProject.getBuild().getFinalName() + ".jar").getAbsolutePath();
        ArrayList<String> result = new ArrayList<String>();
        result.add(projectJar);
        String classpath = this.compilerService.buildClasspath(this.compilerService.resolveDependencies(this.mavenProject, "runtime").stream().filter(dep -> this.isDependencyIncluded(dep.getArtifact())).toList());
        result.addAll(Arrays.asList(classpath.split(File.pathSeparator)));
        return result;
    }

    private List<String> resolveAotClasspath() throws DependencyResolutionException {
        Stream<Artifact> aotArtifacts = Arrays.stream(AOT_MODULES).map(m -> new DefaultArtifact("io.micronaut.aot:micronaut-aot-" + m + ":" + this.micronautAotVersion));
        return DependencyResolutionService.toClasspath(this.dependencyResolutionService.artifactResultsFor(aotArtifacts, false).stream().filter(r -> this.isDependencyIncluded(r.getArtifact())).toList());
    }

    private List<String> resolveAotPluginsClasspath() throws DependencyResolutionException {
        if (this.aotDependencies != null && !this.aotDependencies.isEmpty()) {
            Stream<Artifact> aotPlugins = this.aotDependencies.stream().map(d -> new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getType(), d.getVersion()));
            return DependencyResolutionService.toClasspath(this.dependencyResolutionService.artifactResultsFor(aotPlugins, false).stream().filter(r -> this.isDependencyIncluded(r.getArtifact())).toList());
        }
        return Collections.emptyList();
    }

    private boolean isDependencyIncluded(Artifact dependency) {
        if (this.aotExclusions == null) {
            return true;
        }
        return this.aotExclusions.stream().noneMatch(e -> e.getGroupId().equals(dependency.getGroupId()) && e.getArtifactId().equals(dependency.getArtifactId()));
    }
}

