/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.testresources.AbstractTestResourcesMojo;
import io.micronaut.maven.testresources.TestResourcesHelper;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

@Mojo(name="start-testresources-service", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartTestResourcesServerMojo
extends AbstractTestResourcesMojo {
    public static final String NAME = "start-testresources-service";
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final DependencyResolutionService dependencyResolutionService;
    private final ToolchainManager toolchainManager;

    @Inject
    public StartTestResourcesServerMojo(MavenProject mavenProject, MavenSession mavenSession, DependencyResolutionService dependencyResolutionService, ToolchainManager toolchainManager) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.dependencyResolutionService = dependencyResolutionService;
        this.toolchainManager = toolchainManager;
    }

    public final void execute() throws MojoExecutionException {
        if (this.isTestExecutionSkipped()) {
            this.getLog().debug((CharSequence)"Skipping test resources service start because test execution is disabled");
            return;
        }
        TestResourcesHelper helper = new TestResourcesHelper(this.testResourcesEnabled, this.shared, this.buildDirectory, this.explicitPort, this.clientTimeout, this.serverIdleTimeoutMinutes, this.mavenProject, this.mavenSession, this.dependencyResolutionService, this.toolchainManager, this.testResourcesVersion, this.classpathInference, this.testResourcesDependencies, this.sharedServerNamespace, this.debugServer, this.foreground, this.testResourcesSystemProperties);
        helper.start();
    }

    boolean isTestExecutionSkipped() {
        try {
            MojoExecution execution = new MojoExecution(this.mavenProject.getPlugin("io.micronaut.maven:micronaut-maven-plugin"), null, null);
            PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(this.mavenSession, execution);
            return this.isPropertyTrue(evaluator, "skipTests") || this.isPropertyTrue(evaluator, "maven.test.skip") || this.isPropertyTrue(evaluator, "skipITs");
        }
        catch (ExpressionEvaluationException e) {
            this.getLog().debug((CharSequence)("Could not evaluate test skip properties: " + e.getMessage()));
            return false;
        }
    }

    private boolean isPropertyTrue(PluginParameterExpressionEvaluator evaluator, String propertyName) throws ExpressionEvaluationException {
        Object propertyValue = evaluator.evaluate("${" + propertyName + "}");
        if (propertyValue instanceof Boolean) {
            return (Boolean)propertyValue;
        }
        if (propertyValue instanceof String) {
            return Boolean.parseBoolean((String)propertyValue);
        }
        return false;
    }
}

