/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import com.google.cloud.tools.jib.api.Credential;
import io.micronaut.maven.jib.JibConfigurationService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.RegistryAuthLocator;

@Singleton
public class DockerService {
    private static final Logger LOG = LoggerFactory.getLogger(DockerService.class);
    private final DockerClient dockerClient;
    private final DockerClientConfig config;
    private final MavenProject mavenProject;
    private final JibConfigurationService jibConfigurationService;

    @Inject
    public DockerService(MavenProject mavenProject, JibConfigurationService jibConfigurationService) {
        this.mavenProject = mavenProject;
        this.jibConfigurationService = jibConfigurationService;
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(this.config.getDockerHost()).sslConfig((SSLConfig)this.config.getSSLConfig()).build();
        this.dockerClient = DockerClientImpl.getInstance((DockerClientConfig)this.config, (DockerHttpClient)httpClient);
    }

    public BuildImageCmd buildImageCmd(String dockerfileName) throws IOException {
        this.verifyDockerRunning();
        BuildImageCmd buildImageCmd = this.dockerClient.buildImageCmd(this.loadDockerfileAsResource(dockerfileName));
        this.maybeConfigureBuildAuth(buildImageCmd);
        return buildImageCmd;
    }

    private void maybeConfigureBuildAuth(BuildImageCmd buildImageCmd) {
        Optional fromImage = this.jibConfigurationService.getFromImage();
        Optional fromCredentials = this.jibConfigurationService.getFromCredentials();
        if (fromImage.isPresent() && fromCredentials.isPresent()) {
            AuthConfig authConfig = this.getAuthConfigFor((String)fromImage.get(), ((Credential)fromCredentials.get()).getUsername(), ((Credential)fromCredentials.get()).getPassword());
            AuthConfigurations authConfigurations = new AuthConfigurations();
            authConfigurations.addConfig(authConfig);
            buildImageCmd.withBuildAuthConfigs(authConfigurations);
        }
    }

    public BuildImageCmd buildImageCmd() {
        this.verifyDockerRunning();
        BuildImageCmd buildImageCmd = this.dockerClient.buildImageCmd();
        this.maybeConfigureBuildAuth(buildImageCmd);
        return buildImageCmd;
    }

    public String buildImage(BuildImageCmd builder) {
        this.verifyDockerRunning();
        BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

            public void onNext(BuildResponseItem item) {
                super.onNext(item);
                if (item.isErrorIndicated() && item.getErrorDetail() != null) {
                    LOG.error(item.getErrorDetail().getMessage());
                } else if (item.getStream() != null) {
                    String msg = StringUtils.removeEnd((String)item.getStream(), (String)System.lineSeparator());
                    LOG.info(msg);
                }
            }
        };
        return ((BuildImageResultCallback)builder.exec((ResultCallback)resultCallback)).awaitImageId();
    }

    public void runPrivilegedImageAndWait(String imageId, Integer timeoutSeconds, String checkpointNetworkName, String ... binds) throws IOException {
        block28: {
            this.verifyDockerRunning();
            try (CreateContainerCmd create = this.dockerClient.createContainerCmd(imageId);){
                HostConfig hostConfig = create.getHostConfig();
                if (hostConfig == null) {
                    throw new DockerClientException("When setting binds and privileged, hostConfig was null.  Please check your docker installation and try again");
                }
                hostConfig.withPrivileged(Boolean.valueOf(true));
                if (checkpointNetworkName != null) {
                    hostConfig.withNetworkMode(checkpointNetworkName);
                }
                for (String bind : binds) {
                    hostConfig.withBinds(new Bind[]{Bind.parse((String)bind)});
                }
                CreateContainerResponse createResponse = create.exec();
                try (StartContainerCmd start = this.dockerClient.startContainerCmd(createResponse.getId());){
                    start.exec();
                    LOG.info("Container started: {} {}", (Object)createResponse.getId(), (Object)start.getContainerId());
                    try (WaitContainerCmd wait = this.dockerClient.waitContainerCmd(createResponse.getId());){
                        WaitContainerResultCallback waitResult = wait.start();
                        LOG.info("Waiting {} seconds for completion", (Object)timeoutSeconds);
                        Integer exitcode = waitResult.awaitStatusCode((long)timeoutSeconds.intValue(), TimeUnit.SECONDS);
                        if (exitcode == 0) break block28;
                        Slf4jLogConsumer stdoutConsumer = new Slf4jLogConsumer(LOG);
                        Slf4jLogConsumer stderrConsumer = new Slf4jLogConsumer(LOG);
                        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
                            callback.addConsumer(OutputFrame.OutputType.STDOUT, (Consumer)stdoutConsumer);
                            callback.addConsumer(OutputFrame.OutputType.STDERR, (Consumer)stderrConsumer);
                            ((FrameConsumerResultCallback)this.dockerClient.logContainerCmd(start.getContainerId()).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)callback)).awaitCompletion();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        throw new IOException("Image " + imageId + " exited with code " + exitcode);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File copyFromContainer(String imageId, String containerPath) {
        block11: {
            CreateContainerCmd containerCmd = this.dockerClient.createContainerCmd(imageId);
            CreateContainerResponse container = containerCmd.exec();
            this.dockerClient.startContainerCmd(container.getId());
            InputStream nativeImage = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), containerPath).exec();
            try {
                File file;
                TarArchiveInputStream fin = new TarArchiveInputStream(nativeImage);
                try {
                    TarArchiveEntry tarEntry = fin.getNextTarEntry();
                    File file2 = new File(this.mavenProject.getBuild().getDirectory(), tarEntry.getName());
                    if (!file2.getCanonicalFile().toPath().startsWith(this.mavenProject.getBuild().getDirectory())) {
                        throw new IOException("Entry is outside of the target directory");
                    }
                    IOUtils.copy((InputStream)fin, (OutputStream)Files.newOutputStream(file2.toPath(), new OpenOption[0]));
                    file = file2;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error("Failed to copy file from container", (Throwable)e);
                        break block11;
                    }
                }
                fin.close();
                return file;
            }
            finally {
                containerCmd.close();
            }
        }
        return null;
    }

    public File loadDockerfileAsResource(String name) throws IOException {
        return this.loadDockerfileAsResource(name, "Dockerfile");
    }

    public File loadDockerfileAsResource(String name, String targetFileName) throws IOException {
        String path = "/dockerfiles/" + name;
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (stream != null) {
            File dockerfile = new File(this.mavenProject.getBuild().getDirectory(), targetFileName);
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)dockerfile);
            return dockerfile;
        }
        return null;
    }

    public PushImageCmd pushImageCmd(String imageName) {
        this.verifyDockerRunning();
        return this.dockerClient.pushImageCmd(imageName);
    }

    public AuthConfig getAuthConfigFor(String dockerImage, String username, String password) {
        DockerImageName dockerImageName = DockerImageName.parse((String)dockerImage);
        AuthConfig defaultAuthConfig = new AuthConfig().withRegistryAddress(dockerImageName.getRegistry()).withUsername(username).withPassword(password);
        RegistryAuthLocator registryAuthLocator = RegistryAuthLocator.instance();
        AuthConfig authConfig = registryAuthLocator.lookupAuthConfig(dockerImageName, defaultAuthConfig);
        AuthResponse authResponse = this.dockerClient.authCmd().withAuthConfig(authConfig).exec();
        if (authResponse.getStatus() != null && authResponse.getStatus().equals("Login Succeeded")) {
            LOG.info("Successfully logged in to registry {}", (Object)dockerImageName.getRegistry());
        } else {
            LOG.warn("Failed to login to registry {}", (Object)dockerImageName.getRegistry());
        }
        return authConfig;
    }

    private void verifyDockerRunning() {
        try {
            this.dockerClient.pingCmd().exec();
        }
        catch (DockerException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Cannot connect to the Docker daemon at " + this.config.getDockerHost() + ". Is the docker daemon running?", e);
        }
    }
}

