/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import io.micronaut.core.util.StringUtils;
import io.micronaut.testresources.buildtools.MavenDependency;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Singleton
public class DependencyResolutionService {
    public static final String TEST_RESOURCES_GROUP = "io.micronaut.testresources";
    public static final String TEST_RESOURCES_ARTIFACT_ID_PREFIX = "micronaut-test-resources-";
    private static final String JAR_EXTENSION = "jar";
    private final MavenSession mavenSession;
    private final MavenProject mavenProject;
    private final RepositorySystem repositorySystem;

    @Inject
    public DependencyResolutionService(MavenSession mavenSession, MavenProject mavenProject, RepositorySystem repositorySystem) {
        this.mavenSession = mavenSession;
        this.mavenProject = mavenProject;
        this.repositorySystem = repositorySystem;
    }

    private static Stream<File> streamClasspath(List<ArtifactResult> resolutionResult) {
        return resolutionResult.stream().map(ArtifactResult::getArtifact).map(Artifact::getFile);
    }

    public static List<String> toClasspath(List<ArtifactResult> resolutionResult) {
        return DependencyResolutionService.streamClasspath(resolutionResult).map(File::getAbsolutePath).toList();
    }

    public static List<File> toClasspathFiles(List<ArtifactResult> resolutionResult) {
        return DependencyResolutionService.streamClasspath(resolutionResult).toList();
    }

    public static Dependency mavenDependencyToAetherDependency(org.apache.maven.model.Dependency d) {
        Artifact artifact = DependencyResolutionService.mavenDependencyToAetherArtifact(d);
        return new Dependency(artifact, d.getScope(), Boolean.valueOf(d.getOptional()));
    }

    public static Artifact mavenDependencyToAetherArtifact(org.apache.maven.model.Dependency d) {
        return new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion());
    }

    public static MavenDependency mavenDependencyToTestResourcesDependency(org.apache.maven.model.Dependency d) {
        return new MavenDependency(d.getGroupId(), d.getArtifactId(), d.getVersion());
    }

    public static Artifact testResourcesDependencyToAetherArtifact(MavenDependency d) {
        return new DefaultArtifact(d.getGroup(), d.getArtifact(), JAR_EXTENSION, d.getVersion());
    }

    public List<ArtifactResult> artifactResultsFor(Stream<Artifact> artifacts, boolean applyManagedDependencies) throws DependencyResolutionException {
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(this.mavenProject.getRemoteProjectRepositories());
        if (applyManagedDependencies) {
            List dependencies = this.mavenProject.getDependencyManagement().getDependencies();
            HashMap<CallSite, Dependency> dependencyMap = new HashMap<CallSite, Dependency>(dependencies.size());
            for (org.apache.maven.model.Dependency dependency : dependencies) {
                String ga = dependency.getGroupId() + ":" + dependency.getArtifactId();
                dependencyMap.putIfAbsent((CallSite)((Object)ga), DependencyResolutionService.mavenDependencyToAetherDependency(dependency));
            }
            collectRequest.setManagedDependencies(new ArrayList(dependencyMap.values()));
            artifacts.forEach(a -> {
                if (StringUtils.isEmpty((CharSequence)a.getVersion())) {
                    dependencyMap.computeIfPresent((CallSite)((Object)(a.getGroupId() + ":" + a.getArtifactId())), (coord, d) -> {
                        collectRequest.addDependency(new Dependency((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getExtension(), d.getArtifact().getVersion()), "runtime"));
                        return d;
                    });
                } else {
                    collectRequest.addDependency(new Dependency(a, "runtime"));
                }
            });
        } else {
            artifacts.map(a -> new Dependency(a, "runtime")).forEach(arg_0 -> ((CollectRequest)collectRequest).addDependency(arg_0));
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(repositorySession, dependencyRequest);
        return dependencyResult.getArtifactResults();
    }
}

