/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import com.google.common.io.FileWriteMode;
import io.micronaut.maven.AbstractMicronautMojo;
import io.micronaut.maven.core.DockerBuildStrategy;
import io.micronaut.maven.core.MicronautRuntime;
import io.micronaut.maven.jib.JibConfigurationService;
import io.micronaut.maven.jib.JibMicronautExtension;
import io.micronaut.maven.services.ApplicationConfigurationService;
import io.micronaut.maven.services.DockerService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDockerMojo
extends AbstractMicronautMojo {
    public static final String LATEST_TAG = "latest";
    public static final String DEFAULT_BASE_IMAGE_GRAALVM_RUN = "cgr.dev/chainguard/wolfi-base:latest";
    public static final String MOSTLY_STATIC_NATIVE_IMAGE_GRAALVM_FLAG = "-H:+StaticExecutableWithDynamicLibC";
    public static final String ARM_ARCH = "aarch64";
    public static final String X86_64_ARCH = "x64";
    public static final String DEFAULT_ORACLE_LINUX_VERSION = "ol9";
    public static final String ORACLE_CLOUD_FUNCTION_DEFAULT_CMD = "CMD [\"io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest\"]";
    protected final MavenProject mavenProject;
    protected final JibConfigurationService jibConfigurationService;
    protected final ApplicationConfigurationService applicationConfigurationService;
    protected final DockerService dockerService;
    protected final PluginParameterExpressionEvaluator expressionEvaluator;
    @Parameter(property="micronaut.native-image.args")
    protected List<String> nativeImageBuildArgs;
    @Parameter(property="mn.appArgs")
    protected List<String> appArguments;
    @Parameter(defaultValue="${exec.mainClass}", required=true)
    protected String mainClass;
    @Parameter(defaultValue="false", property="micronaut.native-image.static")
    protected Boolean staticNativeImage;
    @Parameter(property="micronaut.runtime", defaultValue="NONE")
    protected String micronautRuntime;
    @Parameter(property="micronaut.native-image.base-image-run", defaultValue="cgr.dev/chainguard/wolfi-base:latest")
    protected String baseImageRun;
    @Parameter(property="micronaut.native-image.ol.version", defaultValue="ol9")
    protected String oracleLinuxVersion;
    @Parameter(property="docker.networkMode")
    protected String networkMode;

    protected AbstractDockerMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService, MavenSession mavenSession, MojoExecution mojoExecution) {
        this.mavenProject = mavenProject;
        this.jibConfigurationService = jibConfigurationService;
        this.applicationConfigurationService = applicationConfigurationService;
        this.dockerService = dockerService;
        this.expressionEvaluator = new PluginParameterExpressionEvaluator(mavenSession, mojoExecution);
    }

    protected ArtifactVersion javaVersion() {
        return new DefaultArtifactVersion(Optional.ofNullable(this.mavenProject.getProperties().getProperty("maven.compiler.target")).orElse(System.getProperty("java.version")));
    }

    protected String graalVmVersion() {
        return this.mavenProject.getProperties().getProperty("graal.version");
    }

    protected String graalVmJvmVersion() {
        return this.javaVersion().getMajorVersion() == 17 ? "17" : "21";
    }

    protected String graalVmArch() {
        return this.isArm() ? ARM_ARCH : X86_64_ARCH;
    }

    protected String getFrom() {
        if (Boolean.TRUE.equals(this.staticNativeImage)) {
            return this.getFromImage().orElse("ghcr.io/graalvm/native-image-community:" + this.graalVmJvmVersion() + "-muslib-" + this.oracleLinuxVersion);
        }
        return this.getFromImage().orElse("ghcr.io/graalvm/native-image-community:" + this.graalVmJvmVersion() + "-" + this.oracleLinuxVersion);
    }

    protected boolean isArm() {
        return switch (System.getProperty("os.arch")) {
            case ARM_ARCH, "arm64" -> true;
            default -> false;
        };
    }

    protected Optional<String> getFromImage() {
        return this.jibConfigurationService.getFromImage();
    }

    protected Set<String> getTags() {
        HashSet<Object> tags = new HashSet<Object>();
        Optional toImageOptional = this.jibConfigurationService.getToImage();
        String imageName = this.mavenProject.getArtifactId();
        if (toImageOptional.isPresent()) {
            String toImage = (String)toImageOptional.get();
            if (toImage.contains(":")) {
                tags.add(toImage);
                imageName = ((String)toImageOptional.get()).split(":")[0];
            } else {
                tags.add(toImage + ":latest");
                imageName = toImage;
            }
        } else {
            tags.add(imageName + ":latest");
        }
        for (String tag : this.jibConfigurationService.getTags()) {
            if (LATEST_TAG.equals(tag) && tags.stream().anyMatch(t -> t.contains(LATEST_TAG))) continue;
            tags.add(String.format("%s:%s", imageName, tag));
        }
        return tags.stream().map(this::evaluateExpression).collect(Collectors.toSet());
    }

    private String evaluateExpression(String expression) {
        try {
            return this.expressionEvaluator.evaluate(expression, String.class).toString();
        }
        catch (Exception e) {
            return expression;
        }
    }

    protected String getPort() {
        String port = this.applicationConfigurationService.getServerPort();
        return "-1".equals(port) ? "8080" : port;
    }

    protected void copyDependencies() throws IOException {
        List<String> imageClasspathScopes = Arrays.asList("compile", "runtime");
        this.mavenProject.setArtifactFilter(artifact -> imageClasspathScopes.contains(artifact.getScope()));
        File target = new File(this.mavenProject.getBuild().getDirectory(), "dependency");
        if (!target.exists()) {
            target.mkdirs();
        }
        for (Artifact dependency : this.mavenProject.getArtifacts()) {
            Files.copy(dependency.getFile().toPath(), target.toPath().resolve(dependency.getFile().getName()), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected String getCmd() {
        return "CMD [" + this.appArguments.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + "]";
    }

    protected Optional<String> getNetworkMode() {
        return Optional.ofNullable(this.networkMode);
    }

    protected String getBaseImage() {
        return JibMicronautExtension.determineBaseImage((String)JibMicronautExtension.getJdkVersion((MavenProject)this.mavenProject), (DockerBuildStrategy)MicronautRuntime.valueOf((String)this.micronautRuntime.toUpperCase()).getBuildStrategy());
    }

    protected void oracleCloudFunctionCmd(File dockerfile) throws IOException {
        if (this.appArguments != null && !this.appArguments.isEmpty()) {
            this.getLog().info((CharSequence)("Using application arguments: " + this.appArguments));
            com.google.common.io.Files.asCharSink((File)dockerfile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)(System.lineSeparator() + this.getCmd()));
        } else {
            com.google.common.io.Files.asCharSink((File)dockerfile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)(System.lineSeparator() + ORACLE_CLOUD_FUNCTION_DEFAULT_CMD));
        }
    }
}

