/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.services.DependencyResolutionService;
import io.micronaut.maven.testresources.DefaultServerFactory;
import io.micronaut.testresources.buildtools.MavenDependency;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerSettings;
import io.micronaut.testresources.buildtools.ServerUtils;
import io.micronaut.testresources.buildtools.TestResourcesClasspath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.DependencyResolutionException;

public class TestResourcesHelper {
    private static final String TEST_RESOURCES_PROPERTIES = "test-resources.properties";
    private static final String PORT_FILE_NAME = "test-resources-port.txt";
    private static final String TEST_RESOURCES_CLIENT_SYSTEM_PROP_PREFIX = "micronaut.test.resources.";
    private static final String TEST_RESOURCES_PROP_SERVER_URI = "micronaut.test.resources.server.uri";
    private static final String TEST_RESOURCES_PROP_ACCESS_TOKEN = "micronaut.test.resources.server.access.token";
    private static final String TEST_RESOURCES_PROP_CLIENT_READ_TIMEOUT = "micronaut.test.resources.server.client.read.timeout";
    private final boolean enabled;
    private final MavenSession mavenSession;
    private final boolean shared;
    private final File buildDirectory;
    private final Log log;
    private Integer explicitPort;
    private Integer clientTimeout;
    private Integer serverIdleTimeoutMinutes;
    private MavenProject mavenProject;
    private DependencyResolutionService dependencyResolutionService;
    private ToolchainManager toolchainManager;
    private String testResourcesVersion;
    private boolean classpathInference;
    private List<Dependency> testResourcesDependencies;
    private String sharedServerNamespace;
    private boolean debugServer;

    public TestResourcesHelper(boolean enabled, boolean shared, File buildDirectory, Integer explicitPort, Integer clientTimeout, Integer serverIdleTimeoutMinutes, MavenProject mavenProject, MavenSession mavenSession, DependencyResolutionService dependencyResolutionService, ToolchainManager toolchainManager, String testResourcesVersion, boolean classpathInference, List<Dependency> testResourcesDependencies, String sharedServerNamespace, boolean debugServer) {
        this(mavenSession, enabled, shared, buildDirectory);
        this.explicitPort = explicitPort;
        this.clientTimeout = clientTimeout;
        this.serverIdleTimeoutMinutes = serverIdleTimeoutMinutes;
        this.mavenProject = mavenProject;
        this.dependencyResolutionService = dependencyResolutionService;
        this.toolchainManager = toolchainManager;
        this.testResourcesVersion = testResourcesVersion;
        this.classpathInference = classpathInference;
        this.testResourcesDependencies = testResourcesDependencies;
        this.sharedServerNamespace = sharedServerNamespace;
        this.debugServer = debugServer;
    }

    public TestResourcesHelper(MavenSession mavenSession, boolean enabled, boolean shared, File buildDirectory) {
        this.mavenSession = mavenSession;
        this.enabled = enabled;
        this.shared = shared;
        this.buildDirectory = buildDirectory;
        this.log = new SystemStreamLog();
    }

    private boolean isKeepAlive() {
        boolean hasKeepAliveFile = Files.exists(this.getKeepAliveFile(), new LinkOption[0]);
        return hasKeepAliveFile || this.isStartExplicitlyInvoked();
    }

    private boolean isStartExplicitlyInvoked() {
        return this.mavenSession.getGoals().stream().anyMatch(goal -> goal.equals("mn:start-testresources-service"));
    }

    public void start() throws MojoExecutionException {
        if (!this.enabled) {
            return;
        }
        try {
            this.doStart();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to start test resources server", e);
        }
    }

    private void doStart() throws IOException {
        AtomicBoolean serverStarted;
        DefaultServerFactory serverFactory;
        Path serverSettingsDirectory;
        Path buildDir;
        String accessToken = UUID.randomUUID().toString();
        Optional<ServerSettings> optionalServerSettings = this.startOrConnectToExistingServer(accessToken, buildDir = this.buildDirectory.toPath(), serverSettingsDirectory = this.getServerSettingsDirectory(), serverFactory = new DefaultServerFactory(this.log, this.toolchainManager, this.mavenSession, serverStarted = new AtomicBoolean(false), this.testResourcesVersion, this.debugServer));
        if (optionalServerSettings.isPresent()) {
            ServerSettings serverSettings = optionalServerSettings.get();
            if (this.shared) {
                if (this.sharedServerNamespace != null) {
                    this.log.info((CharSequence)("Test Resources is configured in shared mode with the namespace: " + this.sharedServerNamespace));
                    Path projectSettingsDirectory = this.serverSettingsDirectoryOf(this.buildDirectory.toPath());
                    Files.createDirectories(projectSettingsDirectory, new FileAttribute[0]);
                    Path source = serverSettingsDirectory.resolve(TEST_RESOURCES_PROPERTIES);
                    Path target = projectSettingsDirectory.resolve(TEST_RESOURCES_PROPERTIES);
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    this.log.info((CharSequence)"Test Resources is configured in shared mode");
                }
            }
            this.setSystemProperties(serverSettings);
            if (serverStarted.get()) {
                if (this.isKeepAlive()) {
                    this.log.info((CharSequence)"Micronaut Test Resources service is started in the background. To stop it, run the following command: 'mvn mn:stop-testresources-service'");
                }
            } else {
                Path keepalive = this.getKeepAliveFile();
                if (!Files.exists(keepalive, new LinkOption[0])) {
                    Files.write(keepalive, "true".getBytes(), new OpenOption[0]);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        try {
                            this.deleteKeepAliveFile();
                        }
                        catch (MojoExecutionException mojoExecutionException) {
                            // empty catch block
                        }
                    }));
                }
            }
        }
    }

    public Map<String, String> computeSystemProperties(ServerSettings serverSettings) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(3);
        String uri = String.format("http://localhost:%d", serverSettings.getPort());
        systemProperties.put(TEST_RESOURCES_PROP_SERVER_URI, uri);
        serverSettings.getAccessToken().ifPresent(accessToken -> systemProperties.put(TEST_RESOURCES_PROP_ACCESS_TOKEN, (String)accessToken));
        serverSettings.getClientTimeout().ifPresent(timeout -> systemProperties.put(TEST_RESOURCES_PROP_CLIENT_READ_TIMEOUT, String.valueOf(timeout)));
        return systemProperties;
    }

    private void setSystemProperties(ServerSettings serverSettings) {
        this.computeSystemProperties(serverSettings).forEach(System::setProperty);
    }

    private Optional<ServerSettings> startOrConnectToExistingServer(String accessToken, Path buildDir, Path serverSettingsDirectory, ServerFactory serverFactory) {
        try {
            return Optional.ofNullable(ServerUtils.startOrConnectToExistingServer((Integer)this.explicitPort, (Path)buildDir.resolve(PORT_FILE_NAME), (Path)serverSettingsDirectory, (String)accessToken, this.resolveServerClasspath(), (Integer)this.clientTimeout, (Integer)this.serverIdleTimeoutMinutes, (ServerFactory)serverFactory));
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Error starting Micronaut Test Resources service", (Throwable)e);
            return Optional.empty();
        }
    }

    private List<File> resolveServerClasspath() throws DependencyResolutionException {
        List<Object> applicationDependencies = Collections.emptyList();
        if (this.classpathInference) {
            applicationDependencies = this.getApplicationDependencies();
        }
        Stream<Artifact> serverDependencies = TestResourcesClasspath.inferTestResourcesClasspath(applicationDependencies, (String)this.testResourcesVersion).stream().map(DependencyResolutionService::testResourcesDependencyToAetherArtifact);
        List<Object> extraDependencies = this.testResourcesDependencies != null ? this.testResourcesDependencies : Collections.emptyList();
        Stream<Artifact> extraDependenciesStream = extraDependencies.stream().map(DependencyResolutionService::mavenDependencyToAetherArtifact);
        Stream<Artifact> artifacts = Stream.concat(serverDependencies, extraDependenciesStream);
        return DependencyResolutionService.toClasspathFiles(this.dependencyResolutionService.artifactResultsFor(artifacts, true));
    }

    private List<MavenDependency> getApplicationDependencies() {
        return this.mavenProject.getDependencies().stream().map(DependencyResolutionService::mavenDependencyToTestResourcesDependency).toList();
    }

    public void stop() throws MojoExecutionException {
        if (!this.enabled) {
            return;
        }
        if (this.isKeepAlive()) {
            this.log.info((CharSequence)"Keeping Micronaut Test Resources service alive");
            return;
        }
        try {
            Optional optionalServerSettings = ServerUtils.readServerSettings((Path)this.getServerSettingsDirectory());
            if (optionalServerSettings.isPresent() && ServerUtils.isServerStarted((int)((ServerSettings)optionalServerSettings.get()).getPort())) {
                this.log.info((CharSequence)"Shutting down Micronaut Test Resources service");
                this.doStop();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Cannot find Micronaut Test Resources service settings, server may already be shutdown.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to stop test resources server", e);
        }
    }

    private void doStop() throws IOException, MojoExecutionException {
        try {
            Path settingsDirectory = this.getServerSettingsDirectory();
            ServerUtils.stopServer((Path)settingsDirectory);
        }
        finally {
            this.deleteKeepAliveFile();
        }
    }

    private void deleteKeepAliveFile() throws MojoExecutionException {
        if (Files.exists(this.getKeepAliveFile(), new LinkOption[0])) {
            try {
                Files.delete(this.getKeepAliveFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete keepalive file", (Exception)e);
            }
        }
    }

    private Path getServerSettingsDirectory() {
        if (this.shared) {
            return ServerUtils.getDefaultSharedSettingsPath((String)this.sharedServerNamespace);
        }
        return this.serverSettingsDirectoryOf(this.buildDirectory.toPath());
    }

    private Path getKeepAliveFile() {
        Path tmpDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
        return tmpDir.resolve("keepalive-" + this.mavenSession.getRequest().getBuilderId());
    }

    private Path serverSettingsDirectoryOf(Path buildDir) {
        return buildDir.resolve("../.micronaut/test-resources");
    }

    public void setSharedServerNamespace(String sharedServerNamespace) {
        this.sharedServerNamespace = sharedServerNamespace;
    }
}

