/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.testresources.TestResourcesConfiguration;
import io.micronaut.maven.testresources.TestResourcesHelper;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="test-resources")
public class TestResourcesLifecycleExtension
extends AbstractMavenLifecycleParticipant {
    private static final String EXPLICIT_START_SERVICE_GOAL_NAME = "mn:start-testresources-service";
    private static final String EXPLICIT_STOP_SERVICE_GOAL_NAME = "mn:stop-testresources-service";
    private final Map<MavenProject, ExpressionEvaluator> perProjectEvaluator = new ConcurrentHashMap<MavenProject, ExpressionEvaluator>();
    private final Map<MavenProject, TestResourcesConfiguration> perProjectConfiguration = new ConcurrentHashMap<MavenProject, TestResourcesConfiguration>();
    private final Logger logger;

    @Inject
    public TestResourcesLifecycleExtension(Logger logger) {
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) {
        session.getAllProjects().forEach(currentProject -> {
            Build build = currentProject.getBuild();
            TestResourcesLifecycleExtension.withPlugin(build, plugin -> {
                List goals;
                TestResourcesConfiguration configuration;
                ExpressionEvaluator evaluator = this.perProjectEvaluator.computeIfAbsent((MavenProject)currentProject, p -> this.initEvaluator((MavenProject)p, session));
                boolean enabled = this.isEnabled(evaluator, configuration = this.perProjectConfiguration.computeIfAbsent((MavenProject)currentProject, mavenProject -> this.initConfiguration((Plugin)plugin)));
                if (enabled && (goals = session.getGoals()).stream().anyMatch(EXPLICIT_START_SERVICE_GOAL_NAME::equals)) {
                    Xpp3Dom flag = new Xpp3Dom("keepAlive");
                    Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
                    pluginConfiguration.addChild(flag);
                    flag.setValue("true");
                }
            });
        });
    }

    public void afterSessionEnd(MavenSession session) {
        if (session.getGoals().stream().noneMatch(s -> s.equals(EXPLICIT_START_SERVICE_GOAL_NAME) || s.equals(EXPLICIT_STOP_SERVICE_GOAL_NAME))) {
            session.getAllProjects().forEach(currentProject -> {
                Build build = currentProject.getBuild();
                TestResourcesLifecycleExtension.withPlugin(build, plugin -> {
                    ExpressionEvaluator evaluator = this.perProjectEvaluator.computeIfAbsent((MavenProject)currentProject, p -> this.initEvaluator((MavenProject)p, session));
                    TestResourcesConfiguration configuration = this.perProjectConfiguration.computeIfAbsent((MavenProject)currentProject, mavenProject -> this.initConfiguration((Plugin)plugin));
                    boolean enabled = this.isEnabled(evaluator, configuration);
                    boolean shared = this.isShared(evaluator, configuration);
                    File buildDirectory = new File(build.getDirectory());
                    TestResourcesHelper helper = new TestResourcesHelper(session, enabled, shared, buildDirectory);
                    if (shared) {
                        String sharedServerNamespace = this.findSharedServerNamespace(evaluator, configuration);
                        helper.setSharedServerNamespace(sharedServerNamespace);
                    }
                    try {
                        helper.stop();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                });
            });
        }
    }

    private String findSharedServerNamespace(ExpressionEvaluator evaluator, TestResourcesConfiguration configuration) {
        try {
            String result = (String)evaluator.evaluate("${micronaut.test.resources.namespace}");
            if (result != null) {
                return result;
            }
            if (configuration != null) {
                return configuration.getSharedServerNamespace();
            }
        }
        catch (ExpressionEvaluationException e) {
            return null;
        }
        return null;
    }

    private boolean isShared(ExpressionEvaluator evaluator, TestResourcesConfiguration configuration) {
        Boolean result = this.evaluateBooleanProperty(evaluator, "micronaut.test.resources.shared");
        if (result != null) {
            return result;
        }
        if (configuration != null) {
            return configuration.isShared();
        }
        return false;
    }

    private boolean isEnabled(ExpressionEvaluator evaluator, TestResourcesConfiguration configuration) {
        Boolean result = this.evaluateBooleanProperty(evaluator, "micronaut.test.resources.enabled");
        if (result != null) {
            return result;
        }
        if (configuration != null) {
            return configuration.isTestResourcesEnabled();
        }
        return false;
    }

    private TestResourcesConfiguration initConfiguration(Plugin plugin) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null) {
            configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
            plugin.setConfiguration((Object)configuration);
        }
        StringWriter writer = new StringWriter();
        Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)configuration);
        return this.parseConfiguration(configuration);
    }

    private TestResourcesConfiguration parseConfiguration(Xpp3Dom dom) {
        TestResourcesConfiguration config = null;
        if (dom != null) {
            Xpp3Dom debugServer;
            Xpp3Dom sharedServerNamespace;
            Xpp3Dom shared;
            config = new TestResourcesConfiguration();
            Xpp3Dom testResourcesEnabled = dom.getChild("testResourcesEnabled");
            if (testResourcesEnabled != null) {
                config.setTestResourcesEnabled(Boolean.parseBoolean(testResourcesEnabled.getValue()));
            }
            if ((shared = dom.getChild("shared")) != null) {
                config.setShared(Boolean.parseBoolean(shared.getValue()));
            }
            if ((sharedServerNamespace = dom.getChild("sharedServerNamespace")) != null) {
                config.setSharedServerNamespace(sharedServerNamespace.getValue());
            }
            if ((debugServer = dom.getChild("debugServer")) != null) {
                config.setShared(Boolean.parseBoolean(debugServer.getValue()));
            }
        }
        return config;
    }

    private Boolean evaluateBooleanProperty(ExpressionEvaluator evaluator, String property) {
        try {
            String s;
            Object result = evaluator.evaluate("${" + property + "}");
            if (result instanceof Boolean) {
                Boolean b = (Boolean)result;
                return b;
            }
            if (result instanceof String && ((s = (String)result).equals(Boolean.TRUE.toString()) || s.equals(Boolean.FALSE.toString()))) {
                return Boolean.parseBoolean(s);
            }
        }
        catch (ExpressionEvaluationException e) {
            return false;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionEvaluator initEvaluator(MavenProject currentProject, MavenSession session) {
        PluginParameterExpressionEvaluator evaluator;
        Plugin thisPlugin = currentProject.getPlugin("io.micronaut.maven:micronaut-maven-plugin");
        MojoExecution execution = new MojoExecution(thisPlugin, null, null);
        MavenProject actualCurrentProject = session.getCurrentProject();
        Map<MavenProject, ExpressionEvaluator> map = this.perProjectEvaluator;
        synchronized (map) {
            session.setCurrentProject(currentProject);
            evaluator = new PluginParameterExpressionEvaluator(session, execution);
            session.setCurrentProject(actualCurrentProject);
        }
        return evaluator;
    }

    private static void withPlugin(Build build, Consumer<? super Plugin> consumer) {
        build.getPlugins().stream().filter(p -> "io.micronaut.maven:micronaut-maven-plugin".equals(p.getGroupId() + ":" + p.getArtifactId())).findFirst().ifPresent(consumer);
    }
}

