/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.openapi;

import io.micronaut.maven.openapi.AbstractOpenApiMojo;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-openapi-generic", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class OpenApiGenericMojo
extends AbstractOpenApiMojo {
    public static final String MOJO_NAME = "generate-openapi-generic";
    public static final String CONFIGURATION_PROPERTIES = "micronaut.openapi.generator.properties";
    @Parameter(property="micronaut.openapi.generator.builder.classname")
    protected String generatorClassName;
    @Parameter(property="micronaut.openapi.generator.properties")
    protected Map<String, String> properties;

    @Override
    protected boolean isEnabled() {
        return this.generatorClassName != null;
    }

    @Override
    protected void configureBuilder(MicronautCodeGeneratorBuilder builder) throws MojoExecutionException {
        MicronautCodeGenerator<? extends GeneratorOptionsBuilder> generator = this.instantiateGenerator();
        try {
            builder.forCodeGenerator(generator, config -> {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    String name = entry.getKey().substring(CONFIGURATION_PROPERTIES.length() + 1);
                    String value = entry.getValue();
                    OpenApiGenericMojo.invokeMethod(name, config, value);
                }
            });
        }
        catch (OpenAPIInvocationException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private MicronautCodeGenerator<? extends GeneratorOptionsBuilder> instantiateGenerator() {
        MicronautCodeGenerator generator;
        try {
            generator = (MicronautCodeGenerator)((Object)((Object)this)).getClass().getClassLoader().loadClass(this.generatorClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return generator;
    }

    private static void invokeMethod(String name, GeneratorOptionsBuilder builder, String value) {
        try {
            Method[] methods;
            String witherName = "with" + StringUtils.capitalize((String)name);
            String setterName = "set" + StringUtils.capitalize((String)name);
            Class<?> builderClazz = builder.getClass();
            for (Method method : methods = builderClazz.getDeclaredMethods()) {
                if (!OpenApiGenericMojo.invokeIfMatches(name, builder, value, witherName, setterName, method)) continue;
                return;
            }
            throw new OpenAPIInvocationException("Unable to find a method on builder " + builderClazz + " with name '" + name + "' which accepts argument '" + value + "'");
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new OpenAPIInvocationException(ex);
        }
    }

    private static boolean invokeIfMatches(String name, GeneratorOptionsBuilder builder, String value, String witherName, String setterName, Method method) throws IllegalAccessException, InvocationTargetException {
        String methodName = method.getName();
        if ((methodName.equals(name) || methodName.equals(witherName) || methodName.equals(setterName)) && method.getParameterCount() == 1) {
            Class<?> parameterType = method.getParameterTypes()[0];
            if (parameterType.equals(String.class)) {
                method.invoke((Object)builder, value);
                return true;
            }
            if (parameterType.equals(Boolean.TYPE)) {
                String coerced = value.toLowerCase(Locale.US);
                if ("true".equals(coerced) || "false".equals(coerced)) {
                    method.invoke((Object)builder, Boolean.parseBoolean(coerced));
                    return true;
                }
            } else if (parameterType.equals(Integer.TYPE) && value.matches("[0-9]+")) {
                method.invoke((Object)builder, Integer.parseInt(value));
                return true;
            }
        }
        return false;
    }

    static class OpenAPIInvocationException
    extends RuntimeException {
        public OpenAPIInvocationException(String message) {
            super(message);
        }

        public OpenAPIInvocationException(Throwable throwable) {
            super(throwable);
        }
    }
}

