/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import io.micronaut.maven.AbstractMicronautMojo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-import-factory", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ImportFactoryMojo
extends AbstractMicronautMojo {
    public static final String MOJO_NAME = "generate-import-factory";
    private static final String MICRONAUT_IMPORTFACTORY_PREFIX = "micronaut.importfactory";
    private final MavenProject project;
    @Parameter(property="micronaut.importfactory.enabled", defaultValue="false")
    private boolean enabled;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/importfactory", property="micronaut.importfactory.outputDirectory", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true", property="micronaut.importfactory.addCompileSourceRoot")
    private boolean addCompileSourceRoot;
    @Parameter(defaultValue="^.*:.*$", property="micronaut.importfactory.includeDependenciesFilter", required=true)
    private String includeDependenciesFilter;
    @Parameter(defaultValue="^$", property="micronaut.importfactory.excludeDependenciesFilter", required=true)
    private String excludeDependenciesFilter;
    @Parameter(defaultValue="^.*$", property="micronaut.importfactory.includePackagesFilter", required=true)
    private String includePackagesFilter;
    @Parameter(defaultValue="^$", property="micronaut.importfactory.excludePackagesFilter", required=true)
    private String excludePackagesFilter;
    @Parameter(property="micronaut.importfactory.targetPackage")
    private String targetPackage;

    @Inject
    public ImportFactoryMojo(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException {
        List<Artifact> dependencies;
        if (!this.enabled) {
            this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " is disabled"));
            return;
        }
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        }
        if ((dependencies = this.getFilteredDependencies()).isEmpty()) {
            this.getLog().warn((CharSequence)"No matching dependencies.");
            return;
        }
        this.getLog().info((CharSequence)("Found " + dependencies.size() + " matching dependencies:"));
        dependencies.forEach(dependency -> this.getLog().info((CharSequence)(this.getIdentifier((Artifact)dependency) + " at " + dependency.getFile())));
        List<String> packages = this.getFilteredPackages(dependencies);
        if (packages.isEmpty()) {
            this.getLog().warn((CharSequence)"No matching packages.");
            return;
        }
        this.getLog().info((CharSequence)("Found " + packages.size() + " matching packages:"));
        packages.forEach(arg_0 -> ((Log)this.getLog()).info(arg_0));
        if (this.targetPackage == null || this.targetPackage.isEmpty()) {
            for (String packageName : packages) {
                try {
                    this.generateImportFactory(packageName, Collections.singletonList(packageName));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating factory for " + packageName, (Exception)e);
                }
            }
        } else {
            try {
                this.generateImportFactory(this.targetPackage, packages);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating factory for " + this.targetPackage, (Exception)e);
            }
        }
    }

    private List<String> getFilteredPackages(List<Artifact> dependencies) throws MojoExecutionException {
        ArrayList<String> packages = new ArrayList<String>();
        for (Artifact dependency : dependencies) {
            packages.addAll(this.getPackages(dependency));
        }
        Pattern includePackages = Pattern.compile(this.includePackagesFilter);
        Pattern excludePackages = Pattern.compile(this.excludePackagesFilter);
        return packages.stream().filter(includePackages.asMatchPredicate()).filter(excludePackages.asMatchPredicate().negate()).sorted().toList();
    }

    private List<Artifact> getFilteredDependencies() {
        Pattern includeDependency = Pattern.compile(this.includeDependenciesFilter);
        Pattern excludeDependency = Pattern.compile(this.excludeDependenciesFilter);
        return this.project.getArtifacts().stream().filter(dependency -> includeDependency.matcher(this.getIdentifier((Artifact)dependency)).matches()).filter(dependency -> !excludeDependency.matcher(this.getIdentifier((Artifact)dependency)).matches()).toList();
    }

    private List<String> getPackages(Artifact artifact) throws MojoExecutionException {
        List<String> list;
        JarFile file = new JarFile(artifact.getFile(), false);
        try {
            list = file.stream().filter(entry -> entry.getName().endsWith(".class") && entry.getName().contains("/")).map(this::getPackageName).distinct().sorted().toList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read " + artifact.getFile(), (Exception)e);
            }
        }
        file.close();
        return list;
    }

    private String getIdentifier(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private String getPackageName(JarEntry entry) {
        String entryName = entry.getName();
        return entryName.substring(0, entryName.lastIndexOf(47)).replace('/', '.');
    }

    private void generateImportFactory(String packageName, List<String> packages) throws IOException {
        Path factoryPath = this.outputDirectory.toPath().resolve(packageName.replace('.', '/')).resolve("ImportFactory.java");
        ArrayList<Object> code = new ArrayList<Object>();
        code.add("package " + packageName + ";");
        code.add("");
        code.add("import io.micronaut.context.annotation.Factory;");
        code.add("import io.micronaut.context.annotation.Import;");
        code.add("import jakarta.annotation.Generated;");
        code.add("");
        code.add("/** Factory which allows Micronaut to import beans from the specified packages. */");
        code.add("@Generated(\"%s\")".formatted("io.micronaut.maven:micronaut-maven-plugin"));
        code.add("@Factory");
        code.add("@Import(");
        code.add("    packages = {");
        for (String name : packages) {
            code.add("      \"" + name + "\",");
        }
        code.add("    })");
        code.add("public class ImportFactory { }\n");
        Files.createDirectories(factoryPath.getParent(), new FileAttribute[0]);
        Files.write(factoryPath, code, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

