/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

public final class MojoUtils {
    private static final String JAVA = "java";

    private MojoUtils() {
    }

    public static String findJavaExecutable(ToolchainManager toolchainManager, MavenSession mavenSession) {
        String executable;
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", mavenSession);
        if (toolchain != null) {
            executable = toolchain.findTool(JAVA);
        } else {
            File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
            executable = Os.isFamily((String)"unix") ? new File(javaBinariesDir, JAVA).getAbsolutePath() : (Os.isFamily((String)"windows") ? new File(javaBinariesDir, "java.exe").getAbsolutePath() : JAVA);
        }
        return executable;
    }

    public static List<String> computeNativeImageArgs(List<String> nativeImageBuildArgs, String baseImageRun, String argsFile) {
        ArrayList<String> allNativeImageBuildArgs = new ArrayList<String>();
        if (nativeImageBuildArgs != null && !nativeImageBuildArgs.isEmpty()) {
            allNativeImageBuildArgs.addAll(nativeImageBuildArgs);
        }
        if (baseImageRun.contains("distroless") && !allNativeImageBuildArgs.contains("-H:+StaticExecutableWithDynamicLibC")) {
            allNativeImageBuildArgs.add("-H:+StaticExecutableWithDynamicLibC");
        }
        List<String> argsFileContent = MojoUtils.parseNativeImageArgsFile(argsFile).toList();
        allNativeImageBuildArgs.addAll(argsFileContent);
        return allNativeImageBuildArgs;
    }

    private static Stream<String> parseNativeImageArgsFile(String argsFile) {
        Path argsFilePath = Paths.get(argsFile, new String[0]);
        if (Files.exists(argsFilePath, new LinkOption[0])) {
            List<String> args;
            try {
                args = Files.readAllLines(argsFilePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read the args file: " + argsFilePath, e);
            }
            if (args.contains("-cp")) {
                int cpPosition = args.indexOf("-cp");
                args.remove(cpPosition);
                args.remove(cpPosition);
            }
            return args.stream().filter(arg -> !arg.startsWith("-H:Name")).filter(arg -> !arg.startsWith("-H:Class")).filter(arg -> !arg.startsWith("-H:Path")).flatMap(arg -> {
                if (arg.startsWith("@")) {
                    String fileName = arg.substring(1);
                    return MojoUtils.parseNativeImageArgsFile(fileName);
                }
                if (arg.startsWith("\\Q") && arg.endsWith("\\E")) {
                    int lastIndexOfSlash = arg.lastIndexOf(File.separator, arg.length() - 3);
                    return Stream.of("\\Q/home/app/libs/" + arg.substring(lastIndexOfSlash + 1));
                }
                if (arg.startsWith("-H:ConfigurationFileDirectories")) {
                    return Stream.of(MojoUtils.parseConfigurationFilesDirectoriesArg(arg));
                }
                return Stream.of(arg);
            });
        }
        throw new RuntimeException("Unable to find args file: " + argsFilePath);
    }

    static String parseConfigurationFilesDirectoriesArg(String arg) {
        String[] split = arg.split("=");
        String[] directories = split[1].split(",");
        String separator = "/";
        if (arg.contains("generateResourceConfig") || arg.contains("generateTestResourceConfig")) {
            return Stream.of(directories).map(FilenameUtils::separatorsToUnix).map(directory -> {
                String[] splitDirectory = directory.split(separator);
                return "/home/app/" + splitDirectory[splitDirectory.length - 1];
            }).collect(Collectors.joining(",")).transform(s -> "-H:ConfigurationFileDirectories=" + s);
        }
        return Stream.of(directories).map(FilenameUtils::separatorsToUnix).map(directory -> {
            String[] splitDirectory = directory.split(separator);
            String last4Directories = splitDirectory[splitDirectory.length - 4] + separator + splitDirectory[splitDirectory.length - 3] + separator + splitDirectory[splitDirectory.length - 2] + separator + splitDirectory[splitDirectory.length - 1];
            return "/home/app/graalvm-reachability-metadata/" + last4Directories;
        }).collect(Collectors.joining(",")).transform(s -> "-H:ConfigurationFileDirectories=" + s);
    }

    public static boolean hasMicronautMavenPlugin(MavenProject project) {
        String[] parts = "io.micronaut.maven:micronaut-maven-plugin".split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        return project.getBuildPlugins().stream().anyMatch(p -> p.getGroupId().equals(groupId) && p.getArtifactId().equals(artifactId));
    }
}

