/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.openapi;

import io.micronaut.maven.AbstractMicronautMojo;
import io.micronaut.maven.openapi.ParameterMapping;
import io.micronaut.maven.openapi.ResponseBodyMapping;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import io.micronaut.openapi.generator.MicronautCodeGeneratorEntryPoint;
import io.micronaut.openapi.generator.MicronautCodeGeneratorOptionsBuilder;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractOpenApiMojo
extends AbstractMicronautMojo {
    static final String MICRONAUT_OPENAPI_PREFIX = "micronaut.openapi";
    static final String IO_MICRONAUT_OPENAPI_PREFIX = "io.micronaut.openapi";
    @Parameter(property="micronaut.openapi.definition", defaultValue="io.micronaut.openapi.invoker", required=true)
    protected File definitionFile;
    @Parameter(property="micronaut.openapi.invoker.package.name", defaultValue="io.micronaut.openapi.invoker", required=true)
    protected String invokerPackageName;
    @Parameter(property="micronaut.openapi.api.package.name", defaultValue="io.micronaut.openapi.api", required=true)
    protected String apiPackageName;
    @Parameter(property="micronaut.openapi.model.package.name", defaultValue="io.micronaut.openapi.model", required=true)
    protected String modelPackageName;
    @Parameter(property="micronaut.openapi.use.bean.validation", defaultValue="true", required=true)
    protected boolean useBeanValidation;
    @Parameter(property="micronaut.openapi.use.one.of.interfaces", defaultValue="true", required=true)
    protected boolean useOneOfInterfaces;
    @Parameter(property="micronaut.openapi.use.optional", defaultValue="false", required=true)
    protected boolean useOptional;
    @Parameter(property="micronaut.openapi.use.reactive", defaultValue="true", required=true)
    protected boolean useReactive;
    @Parameter(property="micronaut.openapi.serialization.framework", defaultValue="MICRONAUT_SERDE_JACKSON", required=true)
    protected String serializationFramework;
    @Parameter(property="micronaut.openapi.always.use.generate.http.response", defaultValue="false", required=true)
    protected boolean alwaysUseGenerateHttpResponse;
    @Parameter(property="micronaut.openapi.generate.http.response.where.required", defaultValue="false", required=true)
    protected boolean generateHttpResponseWhereRequired;
    @Parameter(property="micronaut.openapi.ksp", defaultValue="false", required=true)
    protected boolean ksp;
    @Parameter(property="micronaut.openapi.date.time.format", defaultValue="ZONED_DATETIME", required=true)
    protected String dateTimeFormat;
    @Parameter(property="micronaut.openapi.outputs", required=true, defaultValue="apis,models,supporting_files")
    protected List<String> outputKinds;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/openapi", required=true)
    protected File outputDirectory;
    @Parameter(property="micronaut.openapi.parameterMappings")
    protected List<ParameterMapping> parameterMappings;
    @Parameter(property="micronaut.openapi.responseBodyMappings")
    protected List<ResponseBodyMapping> responseBodyMappings;
    @Parameter(property="micronaut.openapi.schemaMapping")
    protected Map<String, String> schemaMapping;
    @Parameter(property="micronaut.openapi.importMapping")
    protected Map<String, String> importMapping;
    @Parameter(property="micronaut.openapi.nameMapping")
    protected Map<String, String> nameMapping;
    @Parameter(property="micronaut.openapi.typeMapping")
    protected Map<String, String> typeMapping;
    @Parameter(property="micronaut.openapi.enumNameMapping")
    protected Map<String, String> enumNameMapping;
    @Parameter(property="micronaut.openapi.modelNameMapping")
    protected Map<String, String> modelNameMapping;
    @Parameter(property="micronaut.openapi.inlineSchemaNameMapping")
    protected Map<String, String> inlineSchemaNameMapping;
    @Parameter(property="micronaut.openapi.inlineSchemaOption")
    protected Map<String, String> inlineSchemaOption;
    @Parameter(property="micronaut.openapi.openapiNormalizer")
    protected Map<String, String> openapiNormalizer;
    @Parameter(property="micronaut.openapi.apiNamePrefix")
    protected String apiNamePrefix;
    @Parameter(property="micronaut.openapi.apiNameSuffix")
    protected String apiNameSuffix;
    @Parameter(property="micronaut.openapi.modelNamePrefix")
    protected String modelNamePrefix;
    @Parameter(property="micronaut.openapi.modelNameSuffix")
    protected String modelNameSuffix;
    @Parameter(property="micronaut.openapi.lang", defaultValue="java")
    protected String lang;
    @Parameter(property="micronaut.openapi.useEnumCaseInsensitive", defaultValue="false")
    protected boolean useEnumCaseInsensitive;
    @Parameter(property="micronaut.openapi.additionalEnumTypeAnnotations")
    protected List<String> additionalEnumTypeAnnotations;
    @Parameter(property="micronaut.openapi.additionalModelTypeAnnotations")
    protected List<String> additionalModelTypeAnnotations;
    @Parameter(property="micronaut.openapi.additionalOneOfTypeAnnotations")
    protected List<String> additionalOneOfTypeAnnotations;
    @Parameter(property="micronaut.openapi.additionalProperties")
    protected Map<String, Object> additionalProperties;
    @Parameter(property="micronaut.openapi.generateSwaggerAnnotations", defaultValue="false")
    protected boolean generateSwaggerAnnotations;
    @Parameter(property="micronaut.openapi.implicitHeaders", defaultValue="false")
    protected boolean implicitHeaders;
    @Parameter(property="micronaut.openapi.implicitHeadersRegex")
    protected String implicitHeadersRegex;
    @Parameter(property="micronaut.openapi.useJakartaEe", defaultValue="true")
    protected boolean useJakartaEe = true;
    @Parameter(property="micronaut.openapi.sortParamsByRequiredFlag", defaultValue="true")
    protected boolean sortParamsByRequiredFlag = true;
    @Parameter(property="micronaut.openapi.skipOperationExample")
    protected boolean skipOperationExample;
    @Parameter(property="micronaut.openapi.skipSortingOperations")
    protected boolean skipSortingOperations;
    @Parameter(property="micronaut.openapi.removeOperationIdPrefixDelimiter", defaultValue="_")
    protected String removeOperationIdPrefixDelimiter = "_";
    @Parameter(property="micronaut.openapi.removeOperationIdPrefixCount", defaultValue="1")
    protected int removeOperationIdPrefixCount = 1;
    @Parameter(property="micronaut.openapi.sortModelPropertiesByRequiredFlag", defaultValue="true")
    protected boolean sortModelPropertiesByRequiredFlag = true;
    @Parameter(property="micronaut.openapi.ensureUniqueParams", defaultValue="true")
    protected boolean ensureUniqueParams = true;
    @Parameter(property="micronaut.openapi.allowUnicodeIdentifiers")
    protected boolean allowUnicodeIdentifiers;
    @Parameter(property="micronaut.openapi.prependFormOrBodyParameters")
    protected boolean prependFormOrBodyParameters;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected abstract boolean isEnabled();

    protected abstract void configureBuilder(MicronautCodeGeneratorBuilder var1) throws MojoExecutionException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isEnabled()) {
            this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " is disabled"));
            return;
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        MicronautCodeGeneratorBuilder builder = MicronautCodeGeneratorEntryPoint.builder().withDefinitionFile(this.definitionFile.toURI()).withOutputDirectory(this.outputDirectory).withOutputs(this.outputKinds.stream().map(String::toUpperCase).map(MicronautCodeGeneratorEntryPoint.OutputKind::valueOf).toList().toArray(new MicronautCodeGeneratorEntryPoint.OutputKind[0])).withOptions(options -> options.withLang(MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.valueOf((String)this.lang.toUpperCase(Locale.ENGLISH))).withApiPackage(this.apiPackageName).withModelPackage(this.modelPackageName).withInvokerPackage(this.invokerPackageName).withBeanValidation(this.useBeanValidation).withUseOneOfInterfaces(this.useOneOfInterfaces).withOptional(this.useOptional).withReactive(this.useReactive).withSerializationLibrary(SerializationLibraryKind.valueOf((String)this.serializationFramework.toUpperCase(Locale.ENGLISH))).withGenerateHttpResponseAlways(this.alwaysUseGenerateHttpResponse).withGenerateHttpResponseWhereRequired(this.generateHttpResponseWhereRequired).withDateTimeFormat(MicronautCodeGeneratorOptionsBuilder.DateTimeFormat.valueOf((String)this.dateTimeFormat.toUpperCase(Locale.ENGLISH))).withParameterMappings(this.parameterMappings.stream().map(mapping -> new io.micronaut.openapi.generator.ParameterMapping(mapping.getName(), ParameterMapping.ParameterLocation.valueOf((String)mapping.getLocation().name()), mapping.getMappedType(), mapping.getMappedName(), mapping.isValidated())).toList()).withResponseBodyMappings(this.responseBodyMappings.stream().map(mapping -> new io.micronaut.openapi.generator.ResponseBodyMapping(mapping.getHeaderName(), mapping.getMappedBodyType(), mapping.isListWrapper(), mapping.isValidated())).toList()).withSchemaMapping(this.schemaMapping).withImportMapping(this.importMapping).withNameMapping(this.nameMapping).withTypeMapping(this.typeMapping).withEnumNameMapping(this.enumNameMapping).withModelNameMapping(this.modelNameMapping).withInlineSchemaNameMapping(this.inlineSchemaNameMapping).withInlineSchemaOption(this.inlineSchemaOption).withOpenapiNormalizer(this.openapiNormalizer).withApiNamePrefix(this.apiNamePrefix != null ? this.apiNamePrefix : "").withApiNameSuffix(this.apiNameSuffix != null ? this.apiNameSuffix : "").withModelNamePrefix(this.modelNamePrefix != null ? this.modelNamePrefix : "").withModelNameSuffix(this.modelNameSuffix != null ? this.modelNameSuffix : "").withGenerateSwaggerAnnotations(this.generateSwaggerAnnotations).withImplicitHeaders(this.implicitHeaders).withImplicitHeadersRegex(this.implicitHeadersRegex != null ? this.implicitHeadersRegex : "").withUseEnumCaseInsensitive(this.useEnumCaseInsensitive).withAdditionalEnumTypeAnnotations(this.additionalEnumTypeAnnotations).withAdditionalModelTypeAnnotations(this.additionalModelTypeAnnotations).withAdditionalOneOfTypeAnnotations(this.additionalOneOfTypeAnnotations).withAdditionalProperties(this.additionalProperties).withUseJakartaEe(this.useJakartaEe).withSortParamsByRequiredFlag(this.sortParamsByRequiredFlag).withSkipOperationExample(this.skipOperationExample).withSkipSortingOperations(this.skipSortingOperations).withRemoveOperationIdPrefixDelimiter(this.removeOperationIdPrefixDelimiter).withRemoveOperationIdPrefixCount(this.removeOperationIdPrefixCount).withSortModelPropertiesByRequiredFlag(this.sortModelPropertiesByRequiredFlag).withEnsureUniqueParams(this.ensureUniqueParams).withAllowUnicodeIdentifiers(this.allowUnicodeIdentifiers).withPrependFormOrBodyParameters(this.prependFormOrBodyParameters));
        this.configureBuilder(builder);
        builder.build().generate();
    }
}

