/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.openapi;

import io.micronaut.maven.openapi.AbstractOpenApiMojo;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-openapi-client", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class OpenApiClientMojo
extends AbstractOpenApiMojo {
    public static final String MOJO_NAME = "generate-openapi-client";
    private static final String CLIENT_PREFIX = "micronaut.openapi.client.";
    @Parameter(property="micronaut.openapi.client.id")
    protected String clientId;
    @Parameter(property="micronaut.openapi.client.path")
    protected boolean clientPath;
    @Parameter(property="micronaut.openapi.client.use.auth", defaultValue="false")
    protected boolean useAuth;
    @Parameter(property="micronaut.openapi.client.additional.type.annotations")
    protected List<String> additionalTypeAnnotations;
    @Parameter(property="micronaut.openapi.client.base.path.separator")
    protected String basePathSeparator;
    @Parameter(property="micronaut.openapi.client.authorization.filter.pattern")
    protected String authorizationFilterPattern;
    @Parameter(property="micronaut.openapi.generate.client")
    protected boolean enabled;
    @Parameter(property="micronaut.openapi.client.lombok")
    protected boolean lombok;
    @Parameter(property="micronaut.openapi.client.flux.for.arrays")
    protected boolean fluxForArrays;
    @Parameter(property="micronaut.openapi.client.generated.annotation", defaultValue="true")
    protected boolean generatedAnnotation;

    @Override
    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void configureBuilder(MicronautCodeGeneratorBuilder builder) {
        if ("kotlin".equalsIgnoreCase(this.lang)) {
            builder.forKotlinClient(spec -> {
                spec.withAuthorization(this.useAuth).withGeneratedAnnotation(this.generatedAnnotation).withFluxForArrays(this.fluxForArrays).withKsp(this.ksp).withClientPath(this.clientPath);
                if (this.clientId != null && !this.clientId.isEmpty()) {
                    spec.withClientId(this.clientId);
                }
                if (this.additionalTypeAnnotations != null) {
                    spec.withAdditionalClientTypeAnnotations(this.additionalTypeAnnotations);
                }
                if (this.basePathSeparator != null) {
                    spec.withBasePathSeparator(this.basePathSeparator);
                }
                if (this.authorizationFilterPattern != null) {
                    spec.withAuthorizationFilterPattern(this.authorizationFilterPattern);
                }
            });
        } else if ("java".equalsIgnoreCase(this.lang)) {
            builder.forJavaClient(spec -> {
                spec.withAuthorization(this.useAuth).withLombok(this.lombok).withGeneratedAnnotation(this.generatedAnnotation).withFluxForArrays(this.fluxForArrays).withClientPath(this.clientPath);
                if (this.clientId != null && !this.clientId.isEmpty()) {
                    spec.withClientId(this.clientId);
                }
                if (this.additionalTypeAnnotations != null) {
                    spec.withAdditionalClientTypeAnnotations(this.additionalTypeAnnotations);
                }
                if (this.basePathSeparator != null) {
                    spec.withBasePathSeparator(this.basePathSeparator);
                }
                if (this.authorizationFilterPattern != null) {
                    spec.withAuthorizationFilterPattern(this.authorizationFilterPattern);
                }
            });
        } else {
            throw new UnsupportedOperationException("Unsupported language:" + this.lang);
        }
    }
}

