/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.testresources;

import io.micronaut.maven.MojoUtils;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.ToolchainManager;

public class DefaultServerFactory
implements ServerFactory {
    private final Log log;
    private final ToolchainManager toolchainManager;
    private final MavenSession mavenSession;
    private final AtomicBoolean serverStarted;
    private final String testResourcesVersion;
    private final boolean debugServer;
    private final boolean foreground;
    private Process process;

    public DefaultServerFactory(Log log, ToolchainManager toolchainManager, MavenSession mavenSession, AtomicBoolean serverStarted, String testResourcesVersion, boolean debugServer, boolean foreground) {
        this.log = log;
        this.toolchainManager = toolchainManager;
        this.mavenSession = mavenSession;
        this.serverStarted = serverStarted;
        this.testResourcesVersion = testResourcesVersion;
        this.debugServer = debugServer;
        this.foreground = foreground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(ServerUtils.ProcessParameters processParameters) {
        this.log.info((CharSequence)("Starting Micronaut Test Resources service, version " + this.testResourcesVersion));
        ArrayList<String> cli = new ArrayList<String>();
        String javaBin = MojoUtils.findJavaExecutable(this.toolchainManager, this.mavenSession);
        if (javaBin == null) {
            throw new IllegalStateException("Java executable not found");
        }
        cli.add(javaBin);
        cli.addAll(processParameters.getJvmArguments());
        if (this.debugServer) {
            cli.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:8000");
        }
        processParameters.getSystemProperties().forEach((key, value) -> cli.add("-D" + key + "=" + value));
        cli.add("-cp");
        cli.add(processParameters.getClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        String mainClass = processParameters.getMainClass();
        if (mainClass == null) {
            throw new IllegalStateException("Main class is not set");
        }
        cli.add(mainClass);
        cli.addAll(processParameters.getArguments());
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format("Command parameters: %s", String.join((CharSequence)" ", cli)));
        }
        ProcessBuilder builder = new ProcessBuilder(cli);
        try {
            this.process = builder.inheritIO().start();
            if (this.foreground) {
                this.log.info((CharSequence)"Test Resources Service started in foreground. Press Ctrl+C to stop.");
                this.process.waitFor();
            }
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"Failed to start server", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.log.error((CharSequence)"Failed to start server", (Throwable)e);
            this.serverStarted.set(false);
            if (this.process != null) {
                this.process.destroyForcibly();
            }
        }
        finally {
            if (this.process != null) {
                if (this.process.isAlive()) {
                    this.serverStarted.set(true);
                } else {
                    this.process.destroyForcibly();
                }
            }
        }
    }

    public void waitFor(Duration duration) throws InterruptedException {
        if (this.process != null) {
            this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

