/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.openapi;

import io.micronaut.maven.openapi.AbstractOpenApiMojo;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-openapi-server", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class OpenApiServerMojo
extends AbstractOpenApiMojo {
    public static final String MOJO_NAME = "generate-openapi-server";
    private static final String SERVER_PREFIX = "micronaut.openapi.server.";
    @Parameter(property="micronaut.openapi.server.controller.package.name", defaultValue="io.micronaut.openapi.controller.package.name", required=true)
    protected String controllerPackageName;
    @Parameter(property="micronaut.openapi.server.use.auth", defaultValue="false")
    protected boolean useAuth;
    @Parameter(property="micronaut.openapi.server.lombok")
    protected boolean lombok;
    @Parameter(property="micronaut.openapi.server.flux.for.arrays")
    protected boolean fluxForArrays;
    @Parameter(property="micronaut.openapi.server.generated.annotation", defaultValue="true")
    protected boolean generatedAnnotation;
    @Parameter(property="micronaut.openapi.server.aot.compatible")
    protected boolean aotCompatible;
    @Parameter(property="micronaut.openapi.generate.server")
    protected boolean enabled;

    @Override
    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void configureBuilder(MicronautCodeGeneratorBuilder builder) {
        if ("kotlin".equalsIgnoreCase(this.lang)) {
            builder.forKotlinServer(spec -> spec.withControllerPackage(this.controllerPackageName).withAuthentication(this.useAuth).withAot(this.aotCompatible).withGenerateImplementationFiles(false).withGenerateControllerFromExamples(false).withGenerateOperationsToReturnNotImplemented(false).withGeneratedAnnotation(this.generatedAnnotation).withFluxForArrays(this.fluxForArrays).withKsp(this.ksp).withCoroutines(this.coroutines));
        } else if ("java".equalsIgnoreCase(this.lang)) {
            builder.forJavaServer(spec -> spec.withControllerPackage(this.controllerPackageName).withAuthentication(this.useAuth).withAot(this.aotCompatible).withGenerateImplementationFiles(false).withGenerateControllerFromExamples(false).withGenerateOperationsToReturnNotImplemented(false).withGeneratedAnnotation(this.generatedAnnotation).withFluxForArrays(this.fluxForArrays).withLombok(this.lombok));
        } else {
            throw new UnsupportedOperationException("Unsupported language: " + this.lang);
        }
    }
}

