/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation.http.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.micrometer.observation.ObservationPropagationContext;
import io.micronaut.micrometer.observation.http.AbstractObservationFilter;
import io.micronaut.micrometer.observation.http.ObservationHttpExclusionsConfiguration;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientHttpObservationDocumentation;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientRequestObservationContext;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientRequestObservationConvention;
import io.micronaut.micrometer.observation.http.client.instrumentation.DefaultClientRequestObservationConvention;

@Internal
@ClientFilter(value={"${micrometer.observation.http.client.path:/**}"})
@Requires(property="micrometer.observation.http.client.enabled", notEquals="false", defaultValue="true")
public final class ObservationClientFilter
extends AbstractObservationFilter {
    private static final ClientRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultClientRequestObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ClientRequestObservationConvention observationConvention;

    public ObservationClientFilter(ObservationRegistry observationRegistry, @Nullable ClientRequestObservationConvention observationConvention, @Nullable ObservationHttpExclusionsConfiguration exclusionsConfig) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    @RequestFilter
    public void request(MutableHttpRequest<?> request, MutablePropagatedContext mutablePropagatedContext) {
        if (this.shouldExclude(request.getPath())) {
            return;
        }
        ClientRequestObservationContext observationContext = new ClientRequestObservationContext(request);
        Observation observation = ClientHttpObservationDocumentation.HTTP_CLIENT_EXCHANGES.observation(this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).start();
        request.setAttribute((CharSequence)"micrometer.observation", (Object)observation);
        mutablePropagatedContext.add((PropagatedContextElement)new ObservationPropagationContext(observation));
    }

    @ResponseFilter
    public void response(MutableHttpRequest<?> request, HttpResponse<?> response) {
        request.getAttribute((CharSequence)"micrometer.observation", Observation.class).ifPresent(observation -> {
            response.getAttribute((CharSequence)HttpAttributes.EXCEPTION, Throwable.class).ifPresent(arg_0 -> ((Observation)observation).error(arg_0));
            ((ClientRequestObservationContext)observation.getContext()).setResponse(response);
            observation.stop();
        });
    }
}

