/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation.http.client.instrumentation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientHttpObservationDocumentation;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientRequestObservationContext;
import io.micronaut.micrometer.observation.http.client.instrumentation.ClientRequestObservationConvention;

@Internal
public final class DefaultClientRequestObservationConvention
implements ClientRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.client.requests";
    private static final String HOST_HEADER = "host";
    private static final KeyValue URI_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"none");
    private static final KeyValue METHOD_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)"none");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"CLIENT_ERROR");
    private static final KeyValue CLIENT_NAME_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, (String)"none");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue HTTP_URL_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)"none");
    private final String name;

    public DefaultClientRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultClientRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ClientRequestObservationContext context) {
        return "http " + ((MutableHttpRequest)context.getCarrier()).getMethod().name().toLowerCase();
    }

    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.clientName(context), this.exception(context), this.method(context), this.status(context), this.uri(context)});
    }

    private KeyValue uri(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            String uri = ((MutableHttpRequest)context.getCarrier()).getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE).orElse("none");
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)uri);
        }
        return URI_NONE;
    }

    private KeyValue method(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)((MutableHttpRequest)context.getCarrier()).getMethod().name());
        }
        return METHOD_NONE;
    }

    private KeyValue status(ClientRequestObservationContext context) {
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)String.valueOf(response.getStatus().getCode()));
    }

    private KeyValue clientName(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            String serviceId = ((MutableHttpRequest)context.getCarrier()).getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).filter(x -> !x.contains("/")).orElseGet(() -> ((MutableHttpRequest)context.getCarrier()).getHeaders().get((CharSequence)HOST_HEADER, String.class).orElse(((MutableHttpRequest)context.getCarrier()).getUri().getHost()));
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, (String)serviceId);
        }
        return CLIENT_NAME_NONE;
    }

    private KeyValue exception(ClientRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((CharSequence)simpleName) ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.requestUri(context)});
    }

    private KeyValue requestUri(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)((MutableHttpRequest)context.getCarrier()).getUri().toASCIIString());
        }
        return HTTP_URL_NONE;
    }
}

