/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation.http.server;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.micrometer.observation.ObservationPropagationContext;
import io.micronaut.micrometer.observation.http.AbstractObservationFilter;
import io.micronaut.micrometer.observation.http.ObservationHttpExclusionsConfiguration;
import io.micronaut.micrometer.observation.http.server.instrumentation.DefaultServerRequestObservationConvention;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerHttpObservationDocumentation;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerRequestObservationContext;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerRequestObservationConvention;

@Internal
@ServerFilter(value={"${micrometer.observation.http.server.path:/**}"})
@Requires(property="micrometer.observation.http.server.enabled", notEquals="false", defaultValue="true")
public final class ObservationServerFilter
extends AbstractObservationFilter {
    private static final ServerRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultServerRequestObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ServerRequestObservationConvention observationConvention;

    public ObservationServerFilter(ObservationRegistry observationRegistry, @Nullable ServerRequestObservationConvention observationConvention, @Nullable ObservationHttpExclusionsConfiguration exclusionsConfig) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    @RequestFilter
    public void request(HttpRequest<?> request, MutablePropagatedContext mutablePropagatedContext) {
        if (this.shouldExclude(request.getPath())) {
            return;
        }
        ServerRequestObservationContext context = new ServerRequestObservationContext(request);
        Observation observation = ServerHttpObservationDocumentation.HTTP_SERVER_REQUESTS.observation(this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> context, this.observationRegistry).start();
        request.setAttribute((CharSequence)"micrometer.observation", (Object)observation);
        mutablePropagatedContext.add((PropagatedContextElement)new ObservationPropagationContext(observation));
    }

    @ResponseFilter
    public void response(HttpRequest<?> request, MutableHttpResponse<?> response) {
        request.getAttribute((CharSequence)"micrometer.observation", Observation.class).ifPresent(observation -> {
            response.getAttribute((CharSequence)HttpAttributes.EXCEPTION, Throwable.class).ifPresent(arg_0 -> ((Observation)observation).error(arg_0));
            ((ServerRequestObservationContext)observation.getContext()).setResponse(response);
            observation.stop();
        });
    }
}

