/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation.http.server.instrumentation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerHttpObservationDocumentation;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerRequestObservationContext;
import io.micronaut.micrometer.observation.http.server.instrumentation.ServerRequestObservationConvention;
import io.micronaut.web.router.UriRouteInfo;
import java.util.Optional;

@Internal
public final class DefaultServerRequestObservationConvention
implements ServerRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.server.requests";
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"UNKNOWN");
    private static final KeyValue URI_UNKNOWN = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"UNKNOWN");
    private static final KeyValue URI_NOT_FOUND = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"REDIRECTION");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private final String name;

    public DefaultServerRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultServerRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ServerRequestObservationContext context) {
        String httpMethod = ((HttpRequest)context.getCarrier()).getMethod().name().toLowerCase();
        String route = this.getRoute((HttpRequest)context.getCarrier());
        if (route != null) {
            return "http " + httpMethod + " " + route;
        }
        return "http " + httpMethod;
    }

    private String getRoute(HttpRequest<?> request) {
        Optional<String> routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO).filter(UriRouteInfo.class::isInstance).map(ri -> (UriRouteInfo)ri).map(UriRouteInfo::getUriMatchTemplate).map(UriMatchTemplate::toPathString);
        return routeInfo.orElseGet(() -> request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE).map(Object::toString).orElse(null));
    }

    public KeyValues getLowCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), this.method(context), this.status(context), this.uri(context)});
    }

    public KeyValues getHighCardinalityKeyValues(ServerRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.httpUrl(context)});
    }

    private KeyValue method(ServerRequestObservationContext context) {
        return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)((HttpRequest)context.getCarrier()).getMethod().name());
    }

    private KeyValue status(ServerRequestObservationContext context) {
        return context.getResponse() != null ? KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)Integer.toString(((MutableHttpResponse)context.getResponse()).getStatus().getCode())) : STATUS_UNKNOWN;
    }

    private KeyValue uri(ServerRequestObservationContext context) {
        HttpStatus status;
        String route = this.getRoute((HttpRequest)context.getCarrier());
        if (route != null) {
            return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)route);
        }
        if (context.getResponse() != null && (status = ((MutableHttpResponse)context.getResponse()).getStatus()) != null) {
            if (299 < status.getCode() && status.getCode() < 400) {
                return URI_REDIRECTION;
            }
            if (status == HttpStatus.NOT_FOUND) {
                return URI_NOT_FOUND;
            }
        }
        return URI_UNKNOWN;
    }

    private KeyValue exception(ServerRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)ServerHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((CharSequence)simpleName) ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    private KeyValue httpUrl(ServerRequestObservationContext context) {
        return KeyValue.of((KeyName)ServerHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)((HttpRequest)context.getCarrier()).getUri().toString());
    }
}

