/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationPredicate;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.handler.TracingAwareMeterObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.micrometer.observation.ObservationHandlerGrouping;
import io.micronaut.micrometer.observation.ObservationHandlerGroupingClass;
import io.micronaut.micrometer.observation.ObservationProperties;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Factory
@Internal
public final class DefaultObservedFactory {
    public static final int DEFAULT_TRACING_OBSERVATION_HANDLER_ORDER = 2147482647;
    public static final int RECEIVER_TRACING_OBSERVATION_HANDLER_ORDER = 1000;
    public static final int SENDER_TRACING_OBSERVATION_HANDLER_ORDER = 2000;

    @Singleton
    ObservationRegistry observationRegistry(List<ObservationPredicate> observationPredicates, List<GlobalObservationConvention<?>> observationConventions, List<ObservationHandler<?>> observationHandlers, List<ObservationFilter> observationFilters, ObservationHandlerGrouping observationHandlerGrouping) {
        ObservationRegistry observationRegistry = ObservationRegistry.create();
        observationHandlerGrouping.apply(observationHandlers, observationRegistry.observationConfig());
        observationPredicates.forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)observationRegistry.observationConfig()).observationPredicate(arg_0));
        observationFilters.forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)observationRegistry.observationConfig()).observationFilter(arg_0));
        observationConventions.forEach(arg_0 -> ((ObservationRegistry.ObservationConfig)observationRegistry.observationConfig()).observationConvention(arg_0));
        return observationRegistry;
    }

    @Singleton
    @Requirements(value={@Requires(classes={Tracer.class}), @Requires(bean=Tracer.class)})
    @Order(value=2147482647)
    public ObservationHandler<?> defaultTracingObservationHandler(Tracer tracer) {
        return new DefaultTracingObservationHandler(tracer);
    }

    @Singleton
    @Requirements(value={@Requires(classes={Tracer.class}), @Requires(beans={Tracer.class, Propagator.class})})
    @Order(value=2000)
    public ObservationHandler<?> propagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingSenderTracingObservationHandler(tracer, propagator);
    }

    @Singleton
    @Requirements(value={@Requires(classes={Tracer.class}), @Requires(beans={Tracer.class, Propagator.class})})
    @Order(value=1000)
    public ObservationHandler<?> propagatingReceiverTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingReceiverTracingObservationHandler(tracer, propagator);
    }

    @Singleton
    @Requirements(value={@Requires(classes={MeterRegistry.class}), @Requires(beans={MeterRegistry.class}), @Requires(missingBeans={Tracer.class})})
    public ObservationHandler<?> defaultMeterObservationHandler(MeterRegistry meterRegistry) {
        return new DefaultMeterObservationHandler(meterRegistry);
    }

    @Singleton
    @Requirements(value={@Requires(classes={MeterRegistry.class, Tracer.class}), @Requires(beans={MeterRegistry.class, Tracer.class})})
    public ObservationHandler<?> tracingAwareMeterObservationHandler(MeterRegistry meterRegistry, Tracer tracer) {
        DefaultMeterObservationHandler delegate = new DefaultMeterObservationHandler(meterRegistry);
        return new TracingAwareMeterObservationHandler((MeterObservationHandler)delegate, tracer);
    }

    @Singleton
    public static ObservationFilter commonKeyValuesFilter(ObservationProperties properties) {
        if (properties.commonKeyValue() == null || properties.commonKeyValue().isEmpty()) {
            return context -> context;
        }
        KeyValues keyValues = KeyValues.of(properties.commonKeyValue().entrySet(), Map.Entry::getKey, Map.Entry::getValue);
        return context -> context.addLowCardinalityKeyValues(keyValues);
    }

    @Singleton
    ObservationHandlerGrouping observationHandlerGroupingMetricsWithTracer(List<ObservationHandlerGroupingClass> observationHandlerGroupingClasses) {
        return new ObservationHandlerGrouping(observationHandlerGroupingClasses.stream().map(ObservationHandlerGroupingClass::handler).collect(Collectors.toList()));
    }

    @Singleton
    @Requires(classes={MeterObservationHandler.class})
    ObservationHandlerGroupingClass observationHandlerGroupingClassMeter() {
        return new ObservationHandlerGroupingClass(MeterObservationHandler.class);
    }

    @Singleton
    @Requires(classes={TracingObservationHandler.class})
    ObservationHandlerGroupingClass observationHandlerGroupingClassMeterTracer() {
        return new ObservationHandlerGroupingClass(TracingObservationHandler.class);
    }
}

