/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micronaut.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

class ObservationHandlerGrouping {
    private final List<Class<? extends ObservationHandler>> categories;

    ObservationHandlerGrouping(Class<? extends ObservationHandler> category) {
        this(List.of(category));
    }

    ObservationHandlerGrouping(List<Class<? extends ObservationHandler>> categories) {
        this.categories = categories;
    }

    void apply(List<ObservationHandler<?>> handlers, ObservationRegistry.ObservationConfig config) {
        HashMap groupings = new HashMap();
        this.categories.forEach(category -> groupings.put(category, new ArrayList()));
        ArrayList handlersWithoutCategory = new ArrayList();
        for (ObservationHandler<?> observationHandler : handlers) {
            Class<? extends ObservationHandler> category2 = this.findCategory(observationHandler);
            if (category2 != null) {
                ((List)groupings.get(category2)).add(observationHandler);
                continue;
            }
            handlersWithoutCategory.add(observationHandler);
        }
        for (Class clazz : this.categories) {
            List handlerGroup = (List)groupings.get(clazz);
            if (CollectionUtils.isEmpty((Collection)handlerGroup)) continue;
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(handlerGroup));
        }
        for (ObservationHandler observationHandler : handlersWithoutCategory) {
            config.observationHandler(observationHandler);
        }
    }

    private Class<? extends ObservationHandler> findCategory(ObservationHandler<?> handler) {
        for (Class<? extends ObservationHandler> category : this.categories) {
            if (!category.isInstance(handler)) continue;
            return category;
        }
        return null;
    }
}

