/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.micrometer.observation.interceptor;

import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.annotation.Observed;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Singleton
@Requires(beans={ObservationRegistry.class})
@InterceptorBean(value={Observed.class})
final class ObservedInterceptor
implements MethodInterceptor<Object, Object> {
    private final ObservationRegistry observationRegistry;
    private final ConversionService conversionService;

    public ObservedInterceptor(ObservationRegistry observationRegistry, ConversionService conversionService) {
        this.observationRegistry = observationRegistry;
        this.conversionService = conversionService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        boolean isObserved;
        AnnotationValue observed = context.getAnnotation(Observed.class);
        boolean bl = isObserved = observed != null;
        if (!isObserved) {
            return context.proceed();
        }
        String name = observed.stringValue("name").orElse("method.observed");
        String contextualName = (String)((Object)observed.stringValue("contextualName").orElse(context.getDeclaringType().getSimpleName() + "#" + context.getMethodName()));
        String[] lowCardinalityKeyValues = observed.stringValues("lowCardinalityKeyValues");
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        Observation observation = Observation.createNotStarted((String)name, (ObservationRegistry)this.observationRegistry).contextualName(contextualName).lowCardinalityKeyValue("class", context.getDeclaringType().getSimpleName()).lowCardinalityKeyValue("method", context.getMethodName()).lowCardinalityKeyValues(KeyValues.of((String[])lowCardinalityKeyValues));
        observation.start();
        AtomicBoolean stopped = new AtomicBoolean(false);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().propagate();){
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    Object object = observation.scoped(() -> interceptedMethod.handleResult((Object)Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher()).doOnNext(value -> {
                        if (stopped.compareAndSet(false, true)) {
                            observation.stop();
                        }
                    }).doOnError(t -> {
                        observation.error(t);
                        if (stopped.compareAndSet(false, true)) {
                            observation.stop();
                        }
                    }).doOnComplete(() -> {
                        if (stopped.compareAndSet(false, true)) {
                            observation.stop();
                        }
                    })));
                    return object;
                }
                case COMPLETION_STAGE: {
                    CompletionStage<Object> completionStage = (CompletionStage<Object>)observation.scoped(() -> interceptedMethod.interceptResultAsCompletionStage());
                    completionStage = completionStage.whenComplete((o, throwable) -> {
                        if (throwable != null) {
                            observation.error(throwable);
                        }
                        observation.stop();
                    });
                    Object object = interceptedMethod.handleResult(completionStage);
                    return object;
                }
                case SYNCHRONOUS: {
                    Object response = observation.scoped(() -> context.proceed());
                    observation.stop();
                    Object object = response;
                    return object;
                }
            }
            Object object = interceptedMethod.unsupported();
            return object;
        }
        catch (Exception e) {
            observation.error((Throwable)e);
            observation.stop();
            return interceptedMethod.handleException(e);
        }
    }
}

