/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.cloudwatch;

import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Singleton;
import java.util.Properties;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;

@Factory
public class CloudWatchMeterRegistryFactory {
    public static final String CLOUDWATCH_CONFIG = "micronaut.metrics.export.cloudwatch";
    public static final String CLOUDWATCH_ENABLED = "micronaut.metrics.export.cloudwatch.enabled";
    public static final String CLOUDWATCH_DEFAULT_NAMESPACE = "micronaut";

    @Singleton
    CloudWatchAsyncClientBuilder cloudWatchAsyncClientBuilder() {
        return CloudWatchAsyncClient.builder();
    }

    @Bean(preDestroy="close")
    @Singleton
    CloudWatchAsyncClient cloudWatchAsyncClient(CloudWatchAsyncClientBuilder builder) {
        return (CloudWatchAsyncClient)builder.build();
    }

    @Singleton
    CloudWatchMeterRegistry cloudWatchMeterRegistry(ExportConfigurationProperties exportConfigurationProperties, CloudWatchAsyncClient cloudWatchAsyncClient) {
        String cloudwatchNamespace;
        Properties exportConfig = exportConfigurationProperties.getExport();
        if (!exportConfig.containsKey(cloudwatchNamespace = "cloudwatch.namespace")) {
            exportConfig.setProperty(cloudwatchNamespace, CLOUDWATCH_DEFAULT_NAMESPACE);
        }
        return new CloudWatchMeterRegistry(exportConfig::getProperty, Clock.SYSTEM, cloudWatchAsyncClient);
    }
}

