/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.cloudwatch;

import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micronaut.aws.sdk.v2.service.AWSServiceConfiguration;
import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Properties;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;

@Factory
public class CloudWatchMeterRegistryFactory
extends AwsClientFactory<CloudWatchClientBuilder, CloudWatchAsyncClientBuilder, CloudWatchClient, CloudWatchAsyncClient> {
    public static final String CLOUDWATCH_CONFIG = "micronaut.metrics.export.cloudwatch";
    public static final String CLOUDWATCH_ENABLED = "micronaut.metrics.export.cloudwatch.enabled";
    public static final String CLOUDWATCH_DEFAULT_NAMESPACE = "micronaut";

    @Inject
    protected CloudWatchMeterRegistryFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, @Nullable UserAgentProvider userAgentProvider, @Nullable @Named(value="monitoring") AWSServiceConfiguration awsServiceConfiguration) {
        super(credentialsProvider, regionProvider, userAgentProvider, awsServiceConfiguration);
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    public CloudWatchMeterRegistryFactory() {
        this(AwsCredentialsProviderChain.builder().build(), new AwsRegionProviderChain(new AwsRegionProvider[0]), null, null);
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    CloudWatchAsyncClientBuilder cloudWatchAsyncClientBuilder() {
        return this.createAsyncBuilder();
    }

    protected CloudWatchClientBuilder createSyncBuilder() {
        return CloudWatchClient.builder();
    }

    protected CloudWatchAsyncClientBuilder createAsyncBuilder() {
        return CloudWatchAsyncClient.builder();
    }

    @Singleton
    public CloudWatchClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (CloudWatchClientBuilder)super.syncBuilder(httpClient);
    }

    @Bean(preDestroy="close")
    @Singleton
    public CloudWatchClient syncClient(CloudWatchClientBuilder builder) {
        return (CloudWatchClient)super.syncClient((AwsSyncClientBuilder)builder);
    }

    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public CloudWatchAsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (CloudWatchAsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public CloudWatchAsyncClient asyncClient(CloudWatchAsyncClientBuilder builder) {
        return (CloudWatchAsyncClient)super.asyncClient((AwsAsyncClientBuilder)builder);
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    CloudWatchAsyncClient cloudWatchAsyncClient(CloudWatchAsyncClientBuilder builder) {
        return this.asyncClient(builder);
    }

    @Singleton
    CloudWatchMeterRegistry cloudWatchMeterRegistry(ExportConfigurationProperties exportConfigurationProperties, CloudWatchAsyncClient cloudWatchAsyncClient) {
        String cloudwatchNamespace;
        Properties exportConfig = exportConfigurationProperties.getExport();
        if (!exportConfig.containsKey(cloudwatchNamespace = "cloudwatch.namespace")) {
            exportConfig.setProperty(cloudwatchNamespace, CLOUDWATCH_DEFAULT_NAMESPACE);
        }
        return new CloudWatchMeterRegistry(exportConfig::getProperty, Clock.SYSTEM, cloudWatchAsyncClient);
    }
}

