/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Properties;

@Factory
public class GraphiteMeterRegistryFactory {
    public static final String GRAPHITE_CONFIG = "micronaut.metrics.export.graphite";
    public static final String GRAPHITE_TAGS_AS_PREFIX = "micronaut.metrics.export.graphite.tags-as-prefix";
    public static final String GRAPHITE_ENABLED = "micronaut.metrics.export.graphite.enabled";

    @Singleton
    GraphiteMeterRegistry graphiteMeterRegistry(GraphiteConfig config) {
        return new GraphiteMeterRegistry(config, Clock.SYSTEM);
    }

    @Singleton
    GraphiteConfig graphiteConfig(ExportConfigurationProperties exportConfigurationProperties, final @Property(name="micronaut.metrics.export.graphite.tags-as-prefix") @Nullable List<String> tagsAsPrefix) {
        final Properties exportConfig = exportConfigurationProperties.getExport();
        return new GraphiteConfig(){

            public String get(String key) {
                return exportConfig.getProperty(key);
            }

            public String[] tagsAsPrefix() {
                return tagsAsPrefix != null ? tagsAsPrefix.toArray(StringUtils.EMPTY_STRING_ARRAY) : StringUtils.EMPTY_STRING_ARRAY;
            }
        };
    }
}

