/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Properties;

@Factory
public class OtlpMeterRegistryFactory {
    public static final String OTLP_CONFIG = "micronaut.metrics.export.otlp";
    public static final String OTLP_ENABLED = "micronaut.metrics.export.otlp.enabled";

    @Singleton
    @Requirements(value={@Requires(property="micronaut.metrics.enabled", notEquals="false"), @Requires(beans={CompositeMeterRegistry.class})})
    OtlpMeterRegistry otlpMeterRegistry(ExportConfigurationProperties exportConfigurationProperties) {
        Properties exportConfig = exportConfigurationProperties.getExport();
        return new OtlpMeterRegistry(exportConfig::getProperty, Clock.SYSTEM);
    }
}

