/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Properties;

@Factory
public class StatsdMeterRegistryFactory {
    public static final String STATSD_CONFIG = "micronaut.metrics.export.statsd";
    public static final String STATSD_ENABLED = "micronaut.metrics.export.statsd.enabled";

    @Singleton
    @Requirements(value={@Requires(property="micronaut.metrics.enabled", notEquals="false"), @Requires(beans={CompositeMeterRegistry.class})})
    StatsdMeterRegistry statsdMeterRegistry(ExportConfigurationProperties exportConfigurationProperties) {
        Properties exportConfig = exportConfigurationProperties.getExport();
        return new StatsdMeterRegistry(exportConfig::getProperty, Clock.SYSTEM);
    }
}

