/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;

@Internal
final class AdapterIntroduction
implements MethodInterceptor<Object, Object> {
    private final ExecutionHandle<?, ?> executionHandle;

    AdapterIntroduction(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        Class beanType = method.getValue(Adapter.class, "adaptedBean", Class.class).orElse(null);
        String beanMethod = method.getValue(Adapter.class, "adaptedMethod", String.class).orElse(null);
        String beanQualifier = method.getValue(Adapter.class, "adaptedQualifier", String.class).orElse(null);
        Class[] argumentTypes = method.getValue(Adapter.class, "adaptedArgumentTypes", Class[].class).orElse(null);
        if (beanType == null) {
            throw new IllegalStateException("No bean type to adapt found in Adapter configuration for method: " + method);
        }
        if (StringUtils.isEmpty((CharSequence)beanMethod)) {
            throw new IllegalStateException("No bean method to adapt found in Adapter configuration for method: " + method);
        }
        this.executionHandle = StringUtils.isNotEmpty((CharSequence)beanQualifier) ? (ExecutionHandle)beanContext.findExecutionHandle(beanType, Qualifiers.byName((String)beanQualifier), beanMethod, argumentTypes != null ? argumentTypes : method.getArgumentTypes()).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + method + "]. Target method [" + beanMethod + "] not found on bean " + beanType)) : (ExecutionHandle)beanContext.findExecutionHandle(beanType, beanMethod, argumentTypes != null ? argumentTypes : method.getArgumentTypes()).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + method + "]. Target method [" + beanMethod + "] not found on bean " + beanType));
    }

    @Override
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        return this.executionHandle.invoke(context.getParameterValues());
    }
}

