/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.Around;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduced;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.exceptions.UnimplementedAdviceException;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InterceptorChain<B, R>
implements InvocationContext<B, R> {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    protected final Interceptor<B, R>[] interceptors;
    protected final B target;
    protected final ExecutableMethod<B, R> executionHandle;
    protected final MutableConvertibleValues attributes = MutableConvertibleValues.of(new ConcurrentHashMap());
    protected final Map<String, MutableArgumentValue<?>> parameters = new LinkedHashMap();
    private int index = 0;

    public InterceptorChain(Interceptor<B, R>[] interceptors, B target, ExecutableMethod<B, R> method, Object ... originalParameters) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Intercepted method [{}] invocation on target: {}", method, target);
        }
        this.target = target;
        this.executionHandle = method;
        this.interceptors = new Interceptor[interceptors.length + 1];
        System.arraycopy(interceptors, 0, this.interceptors, 0, interceptors.length);
        boolean isIntroduction = target instanceof Introduced;
        this.interceptors[this.interceptors.length - 1] = isIntroduction ? context -> {
            try {
                return method.invoke(target, this.getParameterValues());
            }
            catch (AbstractMethodError e) {
                throw new UnimplementedAdviceException(method);
            }
        } : context -> method.invoke(target, this.getParameterValues());
        Argument[] arguments = method.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = method.getArguments()[i];
            Object value = originalParameters[i];
            this.parameters.put(argument.getName(), MutableArgumentValue.create((Argument)argument, (Object)value));
        }
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.executionHandle.getAnnotationMetadata();
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Argument[] getArguments() {
        return this.executionHandle.getArguments();
    }

    @Override
    public Map<String, MutableArgumentValue<?>> getParameters() {
        return this.parameters;
    }

    public R invoke(B instance, Object ... arguments) {
        return this.proceed();
    }

    @Override
    public B getTarget() {
        return this.target;
    }

    @Override
    public R proceed() throws RuntimeException {
        int len = this.interceptors.length;
        if (len == 0) {
            throw new IllegalStateException("At least one interceptor is required when calling proceed on the interceptor chain!");
        }
        int size = len - 1;
        Interceptor<B, R> interceptor = this.index == size ? this.interceptors[size] : this.interceptors[this.index++];
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proceeded to next interceptor [{}] in chain for method invocation: {}", interceptor, this.executionHandle);
        }
        return interceptor.intercept(this);
    }

    @Override
    public R proceed(Interceptor from) throws RuntimeException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            Interceptor<B, R> interceptor = this.interceptors[i];
            if (interceptor != from) continue;
            this.index = i + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }

    @Internal
    public static Interceptor[] resolveAroundInterceptors(BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        return InterceptorChain.resolveInterceptorsInternal(method, Around.class, interceptors);
    }

    @Internal
    public static Interceptor[] resolveIntroductionInterceptors(BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        Object[] aroundInterceptors = InterceptorChain.resolveAroundInterceptors(beanContext, method, interceptors);
        Object[] introductionInterceptors = InterceptorChain.resolveInterceptorsInternal(method, Introduction.class, interceptors);
        if (introductionInterceptors.length == 0) {
            if (method.hasStereotype(Adapter.class)) {
                introductionInterceptors = new Interceptor[]{new AdapterIntroduction(beanContext, method)};
            } else {
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
        }
        return (Interceptor[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        if (beanContext instanceof ApplicationContext && method instanceof EnvironmentConfigurable) {
            ((EnvironmentConfigurable)method).configure(((ApplicationContext)beanContext).getEnvironment());
        }
    }

    private static Interceptor[] resolveInterceptorsInternal(ExecutableMethod<?, ?> method, Class<? extends Annotation> annotationType, Interceptor[] interceptors) {
        List annotations = method.getAnnotationTypesByStereotype(annotationType);
        Set applicableClasses = annotations.stream().filter(aClass -> {
            if (annotationType == Around.class && aClass.getAnnotation(Introduction.class) != null) {
                return false;
            }
            return annotationType != Introduction.class || aClass.getAnnotation(Around.class) == null;
        }).map(type -> type.getAnnotation(Type.class)).filter(Objects::nonNull).flatMap(type -> Arrays.stream(type.value())).collect(Collectors.toSet());
        Ordered[] interceptorArray = (Interceptor[])Arrays.stream(interceptors).filter(i -> applicableClasses.stream().anyMatch(t -> t.isInstance(i))).toArray(Interceptor[]::new);
        OrderUtil.sort((Ordered[])interceptorArray);
        return interceptorArray;
    }
}

