/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.Adapter;
import io.micronaut.aop.Around;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.exceptions.UnimplementedAdviceException;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    protected final Interceptor<B, R>[] interceptors;
    protected final B target;
    protected final ExecutableMethod<B, R> executionHandle;
    protected final Object[] originalParameters;
    protected MutableConvertibleValues<Object> attributes;
    protected Map<String, MutableArgumentValue<?>> parameters;
    protected final int interceptorCount;
    protected int index = 0;

    public InterceptorChain(Interceptor<B, R>[] interceptors, B target, ExecutableMethod<B, R> method, Object ... originalParameters) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Intercepted method [{}] invocation on target: {}", method, target);
        }
        this.target = target;
        this.originalParameters = originalParameters;
        this.executionHandle = method;
        this.interceptors = interceptors;
        this.interceptorCount = interceptors.length;
    }

    @Override
    public Object[] getParameterValues() {
        return this.originalParameters;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.executionHandle.getAnnotationMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues attributes = this.attributes;
        if (attributes == null) {
            InterceptorChain interceptorChain = this;
            synchronized (interceptorChain) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = MutableConvertibleValues.of(new ConcurrentHashMap(5));
                }
            }
        }
        return attributes;
    }

    public Argument[] getArguments() {
        return this.executionHandle.getArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MutableArgumentValue<?>> getParameters() {
        Map<String, MutableArgumentValue<?>> parameters = this.parameters;
        if (parameters == null) {
            InterceptorChain interceptorChain = this;
            synchronized (interceptorChain) {
                parameters = this.parameters;
                if (parameters == null) {
                    Argument[] arguments = this.executionHandle.getArguments();
                    parameters = new LinkedHashMap(arguments.length);
                    int i = 0;
                    while (i < arguments.length) {
                        final Argument argument = this.executionHandle.getArguments()[i];
                        final int finalIndex = i++;
                        parameters.put(argument.getName(), new MutableArgumentValue<Object>(){

                            public AnnotationMetadata getAnnotationMetadata() {
                                return argument.getAnnotationMetadata();
                            }

                            public Optional<Argument<?>> getFirstTypeVariable() {
                                return argument.getFirstTypeVariable();
                            }

                            public Argument[] getTypeParameters() {
                                return argument.getTypeParameters();
                            }

                            public Map<String, Argument<?>> getTypeVariables() {
                                return argument.getTypeVariables();
                            }

                            @NonNull
                            public String getName() {
                                return argument.getName();
                            }

                            @NonNull
                            public Class<Object> getType() {
                                return argument.getType();
                            }

                            public boolean equalsType(Argument<?> other) {
                                return argument.equalsType(other);
                            }

                            public int typeHashCode() {
                                return argument.typeHashCode();
                            }

                            public Object getValue() {
                                return InterceptorChain.this.originalParameters[finalIndex];
                            }

                            public void setValue(Object value) {
                                InterceptorChain.this.originalParameters[finalIndex] = value;
                            }
                        });
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                    this.parameters = parameters;
                }
            }
        }
        return parameters;
    }

    public R invoke(B instance, Object ... arguments) {
        return this.proceed();
    }

    @Override
    public B getTarget() {
        return this.target;
    }

    @Override
    public R proceed() throws RuntimeException {
        if (this.interceptorCount == 0 || this.index == this.interceptorCount) {
            try {
                return (R)this.executionHandle.invoke(this.target, this.getParameterValues());
            }
            catch (AbstractMethodError e) {
                throw new UnimplementedAdviceException(this.executionHandle);
            }
        }
        Interceptor<B, R> interceptor = this.interceptors[this.index++];
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proceeded to next interceptor [{}] in chain for method invocation: {}", interceptor, this.executionHandle);
        }
        return interceptor.intercept(this);
    }

    @Override
    public R proceed(Interceptor from) throws RuntimeException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            Interceptor<B, R> interceptor = this.interceptors[i];
            if (interceptor != from) continue;
            this.index = i + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }

    @Internal
    public static Interceptor[] resolveAroundInterceptors(BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        return InterceptorChain.resolveInterceptorsInternal(method, Around.class, interceptors);
    }

    @Internal
    public static Interceptor[] resolveIntroductionInterceptors(BeanContext beanContext, ExecutableMethod<?, ?> method, Interceptor ... interceptors) {
        InterceptorChain.instrumentAnnotationMetadata(beanContext, method);
        Object[] aroundInterceptors = InterceptorChain.resolveAroundInterceptors(beanContext, method, interceptors);
        Object[] introductionInterceptors = InterceptorChain.resolveInterceptorsInternal(method, Introduction.class, interceptors);
        if (introductionInterceptors.length == 0) {
            if (method.hasStereotype(Adapter.class)) {
                introductionInterceptors = new Interceptor[]{new AdapterIntroduction(beanContext, method)};
            } else {
                throw new IllegalStateException("At least one @Introduction method interceptor required, but missing. Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @Type(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
            }
        }
        return (Interceptor[])ArrayUtils.concat((Object[])aroundInterceptors, (Object[])introductionInterceptors);
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        if (beanContext instanceof ApplicationContext && method instanceof EnvironmentConfigurable) {
            ((EnvironmentConfigurable)method).configure(((ApplicationContext)beanContext).getEnvironment());
        }
    }

    private static Interceptor[] resolveInterceptorsInternal(ExecutableMethod<?, ?> method, Class<? extends Annotation> annotationType, Interceptor[] interceptors) {
        List annotations = method.getAnnotationTypesByStereotype(annotationType);
        HashSet<Class> applicableClasses = new HashSet<Class>();
        for (Class aClass : annotations) {
            Type typeAnn;
            if (annotationType == Around.class && aClass.getAnnotation(Introduction.class) != null || annotationType == Introduction.class && aClass.getAnnotation(Around.class) != null || (typeAnn = aClass.getAnnotation(Type.class)) == null) continue;
            applicableClasses.addAll(Arrays.asList(typeAnn.value()));
        }
        Ordered[] interceptorArray = (Interceptor[])Arrays.stream(interceptors).filter(i -> applicableClasses.stream().anyMatch(t -> t.isInstance(i))).toArray(Interceptor[]::new);
        OrderUtil.sort((Ordered[])interceptorArray);
        return interceptorArray;
    }
}

