/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.util.CompletableFutureContinuation;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.KotlinUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Internal
final class KotlinInterceptedMethod
implements InterceptedMethod {
    private final MethodInvocationContext<?, ?> context;
    private final Continuation continuation;
    private final Consumer<Object> replaceContinuation;
    private final Argument<?> returnTypeValue;
    private final boolean isUnitValueType;

    private KotlinInterceptedMethod(MethodInvocationContext<?, ?> context, Continuation continuation, Consumer<Object> replaceContinuation, Argument<?> returnTypeValue, boolean isUnitValueType) {
        this.context = context;
        this.continuation = continuation;
        this.returnTypeValue = returnTypeValue;
        this.isUnitValueType = isUnitValueType;
        this.replaceContinuation = replaceContinuation;
    }

    public static KotlinInterceptedMethod of(MethodInvocationContext<?, ?> context) {
        if (!KotlinUtils.KOTLIN_COROUTINES_SUPPORTED || !context.getExecutableMethod().isSuspend()) {
            return null;
        }
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 0) {
            return null;
        }
        int lastParameterIndex = parameterValues.length - 1;
        Object lastArgumentValue = parameterValues[lastParameterIndex];
        if (lastArgumentValue instanceof Continuation) {
            boolean isUnitValueType;
            Continuation continuation = (Continuation)lastArgumentValue;
            Consumer<Object> replaceContinuation = value -> {
                parameterValues[lastParameterIndex] = value;
            };
            Argument returnTypeValue = context.getArguments()[lastParameterIndex].getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            boolean bl = isUnitValueType = returnTypeValue.getType() == Unit.class;
            if (isUnitValueType) {
                returnTypeValue = Argument.VOID_OBJECT;
            }
            return new KotlinInterceptedMethod(context, continuation, replaceContinuation, returnTypeValue, isUnitValueType);
        }
        return null;
    }

    @Override
    public InterceptedMethod.ResultType resultType() {
        return InterceptedMethod.ResultType.COMPLETION_STAGE;
    }

    @Override
    public Argument<?> returnTypeValue() {
        return this.returnTypeValue;
    }

    public CompletableFuture<Object> interceptResultAsCompletionStage() {
        CompletableFutureContinuation completableFutureContinuation;
        if (this.continuation instanceof CompletableFutureContinuation) {
            completableFutureContinuation = (CompletableFutureContinuation)this.continuation;
        } else {
            completableFutureContinuation = new CompletableFutureContinuation((Continuation<Object>)this.continuation);
            this.replaceContinuation.accept(completableFutureContinuation);
        }
        Object result = this.context.proceed();
        this.replaceContinuation.accept(this.continuation);
        if (result != KotlinUtils.COROUTINE_SUSPENDED) {
            completableFutureContinuation.resumeWith(result);
        }
        return completableFutureContinuation.getCompletableFuture();
    }

    public CompletableFuture<Object> interceptResultAsCompletionStage(Interceptor<?, ?> from) {
        CompletableFutureContinuation completableFutureContinuation;
        if (this.continuation instanceof CompletableFutureContinuation) {
            completableFutureContinuation = (CompletableFutureContinuation)this.continuation;
        } else {
            completableFutureContinuation = new CompletableFutureContinuation((Continuation<Object>)this.continuation);
            this.replaceContinuation.accept(completableFutureContinuation);
        }
        Object result = this.context.proceed(from);
        this.replaceContinuation.accept(this.continuation);
        if (result != KotlinUtils.COROUTINE_SUSPENDED) {
            completableFutureContinuation.resumeWith(result);
        }
        return completableFutureContinuation.getCompletableFuture();
    }

    @Override
    public Object interceptResult() {
        return this.interceptResultAsCompletionStage();
    }

    @Override
    public Object interceptResult(Interceptor<?, ?> from) {
        return this.interceptResultAsCompletionStage((Interceptor)from);
    }

    @Override
    public Object handleResult(Object result) {
        if (!(result instanceof CompletionStage)) {
            throw new IllegalStateException("Cannot convert " + result + "  to 'java.util.concurrent.CompletionStage'");
        }
        CompletionStage completionStageResult = (CompletionStage)result;
        completionStageResult.whenComplete((value, throwable) -> {
            if (throwable == null) {
                if (value == null && this.isUnitValueType) {
                    value = Unit.INSTANCE;
                }
                CompletableFutureContinuation.Companion.completeSuccess((Continuation<Object>)this.continuation, value);
            } else {
                if (throwable instanceof CompletionException) {
                    throwable = ((CompletionException)throwable).getCause();
                }
                CompletableFutureContinuation.Companion.completeExceptionally((Continuation<Object>)this.continuation, (Throwable)throwable);
            }
        });
        return KotlinUtils.COROUTINE_SUSPENDED;
    }

    @Override
    public <E extends Throwable> Object handleException(Exception exception) throws E {
        CompletableFutureContinuation.Companion.completeExceptionally((Continuation<Object>)this.continuation, exception);
        return KotlinUtils.COROUTINE_SUSPENDED;
    }
}

