/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
final class CompletionStageInterceptedMethod
implements InterceptedMethod {
    private final MethodInvocationContext<?, ?> context;
    private final ConversionService conversionService;
    private final Argument<?> returnTypeValue;

    CompletionStageInterceptedMethod(MethodInvocationContext<?, ?> context, ConversionService conversionService) {
        this.context = context;
        this.conversionService = conversionService;
        this.returnTypeValue = context.getReturnType().asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
    }

    @Override
    public InterceptedMethod.ResultType resultType() {
        return InterceptedMethod.ResultType.COMPLETION_STAGE;
    }

    @Override
    public Argument<?> returnTypeValue() {
        return this.returnTypeValue;
    }

    @Override
    public Object interceptResult() {
        return this.interceptResultAsCompletionStage();
    }

    @Override
    public Object interceptResult(Interceptor<?, ?> from) {
        return this.interceptResultAsCompletionStage(from);
    }

    public CompletionStage<Object> interceptResultAsCompletionStage() {
        return this.convertToCompletionStage(this.context.proceed());
    }

    public CompletionStage<Object> interceptResultAsCompletionStage(Interceptor<?, ?> from) {
        return this.convertToCompletionStage(this.context.proceed(from));
    }

    @Override
    public Object handleResult(Object result) {
        if (result == null) {
            result = CompletableFuture.completedFuture(null);
        }
        return this.convertCompletionStageResult(this.context.getReturnType(), result);
    }

    @Override
    public <E extends Throwable> Object handleException(Exception exception) throws E {
        CompletableFuture newFuture = new CompletableFuture();
        newFuture.completeExceptionally(exception);
        return this.convertCompletionStageResult(this.context.getReturnType(), newFuture);
    }

    private CompletionStage<Object> convertToCompletionStage(Object result) {
        if (result instanceof CompletionStage) {
            return (CompletionStage)result;
        }
        throw new IllegalStateException("Cannot convert " + result + "  to 'java.util.concurrent.CompletionStage'");
    }

    private Object convertCompletionStageResult(ReturnType<?> returnType, Object result) {
        Class returnTypeClass = returnType.getType();
        if (returnTypeClass.isInstance(result)) {
            return result;
        }
        if (result instanceof CompletionStage && (returnTypeClass == CompletableFuture.class || returnTypeClass == Future.class)) {
            return ((CompletionStage)result).toCompletableFuture();
        }
        return this.conversionService.convert(result, returnType.asArgument()).orElseThrow(() -> new IllegalStateException("Cannot convert completion stage result: " + result + " to '" + returnType.getType().getName() + "'"));
    }
}

