/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.propagation.instrument.rxjava3;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

@Requires(classes={RxJavaPlugins.class})
@Context
@Internal
final class RxJava3Instrumentation {
    private Function<? super Runnable, ? extends Runnable> scheduleHandler;

    RxJava3Instrumentation() {
    }

    @PostConstruct
    void init() {
        this.scheduleHandler = RxJavaPlugins.getScheduleHandler();
        RxJavaPlugins.setScheduleHandler(runnable -> {
            if (this.scheduleHandler != null) {
                runnable = (Runnable)this.scheduleHandler.apply(runnable);
            }
            return PropagatedContext.wrapCurrent((Runnable)runnable);
        });
    }

    @PreDestroy
    void removeInstrumentation() {
        RxJavaPlugins.setScheduleHandler(this.scheduleHandler);
    }
}

