/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.propagation.instrument.execution;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.propagation.instrument.execution.ContextPropagatingExecutorService;
import io.micronaut.context.propagation.instrument.execution.ContextPropagatingScheduledExecutorService;
import io.micronaut.core.annotation.Internal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@Prototype
@Internal
final class ExecutorServiceInstrumenter
implements BeanCreatedEventListener<ExecutorService> {
    ExecutorServiceInstrumenter() {
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        Class beanType = event.getBeanDefinition().getBeanType();
        if (beanType != ExecutorService.class) {
            return (ExecutorService)event.getBean();
        }
        ExecutorService executorService = (ExecutorService)event.getBean();
        if (ContextPropagatingExecutorService.isInstrumented(executorService)) {
            return executorService;
        }
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledExecutorService service = (ScheduledExecutorService)executorService;
            return new ContextPropagatingScheduledExecutorService(service);
        }
        return new ContextPropagatingExecutorService(executorService);
    }
}

