/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.propagation.instrument.execution;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@Prototype
@Internal
final class ExecutorServiceInstrumenter
implements BeanCreatedEventListener<ExecutorService> {
    ExecutorServiceInstrumenter() {
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        Class beanType = event.getBeanDefinition().getBeanType();
        if (beanType != ExecutorService.class) {
            return (ExecutorService)event.getBean();
        }
        final ExecutorService executorService = (ExecutorService)event.getBean();
        if (executorService instanceof InstrumentedExecutorService) {
            return executorService;
        }
        if (executorService instanceof ScheduledExecutorService) {
            final ScheduledExecutorService service = (ScheduledExecutorService)executorService;
            return new InstrumentedScheduledExecutorService(){

                public ScheduledExecutorService getTarget() {
                    return service;
                }

                public <T> Callable<T> instrument(Callable<T> task) {
                    return PropagatedContext.wrapCurrent(task);
                }

                public Runnable instrument(Runnable command) {
                    return PropagatedContext.wrapCurrent((Runnable)command);
                }
            };
        }
        return new InstrumentedExecutorService(){

            public ExecutorService getTarget() {
                return executorService;
            }

            public <T> Callable<T> instrument(Callable<T> task) {
                return PropagatedContext.wrapCurrent(task);
            }

            public Runnable instrument(Runnable command) {
                return PropagatedContext.wrapCurrent((Runnable)command);
            }
        };
    }
}

