/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.processor;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.bind.DefaultExecutableBeanContextBinder;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.EvaluatedAnnotationValue;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.ScheduledExecutorTaskScheduler;
import io.micronaut.scheduling.TaskExceptionHandler;
import io.micronaut.scheduling.TaskScheduler;
import io.micronaut.scheduling.annotation.Scheduled;
import io.micronaut.scheduling.exceptions.SchedulerConfigurationException;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ScheduledMethodProcessor
implements ExecutableMethodProcessor<Scheduled>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskScheduler.class);
    private static final String MEMBER_FIXED_RATE = "fixedRate";
    private static final String MEMBER_INITIAL_DELAY = "initialDelay";
    private static final String MEMBER_CRON = "cron";
    private static final String MEMBER_ZONE_ID = "zoneId";
    private static final String MEMBER_FIXED_DELAY = "fixedDelay";
    private static final String MEMBER_SCHEDULER = "scheduler";
    private static final String MEMBER_CONDITION = "condition";
    private final BeanContext beanContext;
    private final ConversionService conversionService;
    private final Queue<ScheduledFuture<?>> scheduledTasks = new ConcurrentLinkedDeque();
    private final TaskExceptionHandler<?, ?> taskExceptionHandler;

    public ScheduledMethodProcessor(BeanContext beanContext, Optional<ConversionService> conversionService, TaskExceptionHandler<?, ?> taskExceptionHandler) {
        this.beanContext = beanContext;
        this.conversionService = conversionService.orElse(ConversionService.SHARED);
        this.taskExceptionHandler = taskExceptionHandler;
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        if (!(this.beanContext instanceof ApplicationContext)) {
            return;
        }
        List scheduledAnnotations = method.getAnnotationValuesByType(Scheduled.class);
        for (AnnotationValue scheduledAnnotation : scheduledAnnotations) {
            ScheduledFuture<?> scheduledFuture;
            Duration duration;
            Optional converted;
            ScheduledFuture<?> scheduledFuture2;
            String scheduler;
            Optional<TaskScheduler> optionalTaskScheduler;
            String fixedRate = scheduledAnnotation.stringValue(MEMBER_FIXED_RATE).orElse(null);
            String initialDelayStr = scheduledAnnotation.stringValue(MEMBER_INITIAL_DELAY).orElse(null);
            Duration initialDelay = null;
            if (StringUtils.hasText((CharSequence)initialDelayStr)) {
                initialDelay = (Duration)this.conversionService.convert((Object)initialDelayStr, Duration.class).orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid initial delay definition: " + initialDelayStr));
            }
            if ((optionalTaskScheduler = this.beanContext.findBean(TaskScheduler.class, Qualifiers.byName((String)(scheduler = scheduledAnnotation.stringValue(MEMBER_SCHEDULER).orElse("scheduled"))))).isEmpty()) {
                optionalTaskScheduler = this.beanContext.findBean(ExecutorService.class, Qualifiers.byName((String)scheduler)).filter(ScheduledExecutorService.class::isInstance).map(ScheduledExecutorTaskScheduler::new);
            }
            TaskScheduler taskScheduler = (TaskScheduler)optionalTaskScheduler.orElseThrow(() -> new SchedulerConfigurationException(method, "No scheduler of type TaskScheduler configured for name: " + scheduler));
            Argument beanType = beanDefinition.asArgument();
            Qualifier declaredQualifier = beanDefinition.getDeclaredQualifier();
            Runnable task = () -> {
                try {
                    boolean shouldRun;
                    DefaultExecutableBeanContextBinder binder = new DefaultExecutableBeanContextBinder();
                    BoundExecutable boundExecutable = binder.bind((Executable)method, this.beanContext);
                    Object bean = this.beanContext.getBean(beanType, declaredQualifier);
                    AnnotationValue finalAnnotationValue = scheduledAnnotation;
                    if (finalAnnotationValue instanceof EvaluatedAnnotationValue) {
                        EvaluatedAnnotationValue evaluated = (EvaluatedAnnotationValue)finalAnnotationValue;
                        finalAnnotationValue = evaluated.withArguments(bean, boundExecutable.getBoundArguments());
                    }
                    if (shouldRun = finalAnnotationValue.booleanValue(MEMBER_CONDITION).orElse(true).booleanValue()) {
                        try {
                            boundExecutable.invoke(bean);
                        }
                        catch (Throwable e) {
                            this.handleException(beanType.getType(), bean, e);
                        }
                    }
                }
                catch (Exception e) {
                    TaskExceptionHandler finalHandler = this.findHandler(beanDefinition.getBeanType(), e);
                    finalHandler.handleCreationFailure(beanDefinition, e);
                }
            };
            String cronExpr = scheduledAnnotation.stringValue(MEMBER_CRON).orElse(null);
            String zoneIdStr = scheduledAnnotation.stringValue(MEMBER_ZONE_ID).orElse(null);
            String fixedDelay = scheduledAnnotation.stringValue(MEMBER_FIXED_DELAY).orElse(null);
            if (StringUtils.isNotEmpty((CharSequence)cronExpr)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling cron task [{}] for method: {}", (Object)cronExpr, method);
                }
                scheduledFuture2 = taskScheduler.schedule(cronExpr, zoneIdStr, task);
                this.scheduledTasks.add(scheduledFuture2);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)fixedRate)) {
                converted = this.conversionService.convert((Object)fixedRate, Duration.class);
                duration = (Duration)converted.orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid fixed rate definition: " + fixedRate));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling fixed rate task [{}] for method: {}", (Object)duration, method);
                }
                scheduledFuture = taskScheduler.scheduleAtFixedRate(initialDelay, duration, task);
                this.scheduledTasks.add(scheduledFuture);
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)fixedDelay)) {
                converted = this.conversionService.convert((Object)fixedDelay, Duration.class);
                duration = (Duration)converted.orElseThrow(() -> new SchedulerConfigurationException(method, "Invalid fixed delay definition: " + fixedDelay));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling fixed delay task [{}] for method: {}", (Object)duration, method);
                }
                scheduledFuture = taskScheduler.scheduleWithFixedDelay(initialDelay, duration, task);
                this.scheduledTasks.add(scheduledFuture);
                continue;
            }
            if (initialDelay != null) {
                scheduledFuture2 = taskScheduler.schedule(initialDelay, task);
                this.scheduledTasks.add(scheduledFuture2);
                continue;
            }
            throw new SchedulerConfigurationException(method, "Failed to schedule task. Invalid definition");
        }
    }

    private void handleException(Class<Object> beanType, Object bean, Throwable e) {
        TaskExceptionHandler finalHandler = this.findHandler(beanType, e);
        finalHandler.handle(bean, e);
    }

    private TaskExceptionHandler findHandler(Class<?> beanType, Throwable e) {
        Qualifier qualifier = Qualifiers.byTypeArguments((Class[])new Class[]{beanType, e.getClass()});
        Collection definitions = this.beanContext.getBeanDefinitions(TaskExceptionHandler.class, qualifier);
        Optional<BeanDefinition> mostSpecific = definitions.stream().filter(def -> {
            List typeArguments = def.getTypeArguments(TaskExceptionHandler.class);
            if (typeArguments.size() == 2) {
                return ((Argument)typeArguments.get(0)).getType() == beanType && ((Argument)typeArguments.get(1)).getType() == e.getClass();
            }
            return false;
        }).findFirst();
        TaskExceptionHandler<?, ?> finalHandler = mostSpecific.map(bd -> (TaskExceptionHandler)this.beanContext.getBean(bd.getBeanType(), qualifier)).orElse(this.taskExceptionHandler);
        return finalHandler;
    }

    @Override
    @PreDestroy
    public void close() {
        for (ScheduledFuture scheduledFuture : this.scheduledTasks) {
            if (scheduledFuture.isCancelled()) continue;
            scheduledFuture.cancel(false);
        }
    }
}

