/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.converters.time;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.util.StringUtils;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TypeHint(value={Duration.class, TemporalAmount.class, Instant.class, LocalTime.class, LocalDate.class, LocalDateTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneId.class, ZoneOffset.class}, accessType={TypeHint.AccessType.ALL_PUBLIC})
@Internal
public class TimeConverterRegistrar
implements TypeConverterRegistrar {
    private static final Pattern PERIOD_MATCHER = Pattern.compile("^(-?\\d+)([unywmd])(s?)$");
    private static final Pattern DURATION_MATCHER = Pattern.compile("^(-?\\d+)([unsmhd])(s?)$");
    private static final int MILLIS = 3;
    private static final DateTimeFormatter ISO_YEAR = new DateTimeFormatterBuilder().parseLenient().appendValue(ChronoField.YEAR, 1, 10, SignStyle.NORMAL).toFormatter();
    private static final DateTimeFormatter ISO_YEAR_MONTH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
    private static final DateTimeFormatter ISO_MONTH_DAY = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private final Map<String, DateTimeFormatter> formattersCache = new ConcurrentHashMap<String, DateTimeFormatter>();

    public void register(MutableConversionService conversionService) {
        BiFunction<CharSequence, ConversionContext, Optional<Duration>> durationConverter = this.durationConverter();
        conversionService.addConverter(CharSequence.class, Duration.class, (object, targetType, context) -> (Optional)durationConverter.apply((CharSequence)object, context));
        conversionService.addConverter(Integer.class, Duration.class, (integer, targetType, context) -> (Optional)durationConverter.apply(integer.toString(), context));
        conversionService.addConverter(CharSequence.class, TemporalAmount.class, (object, targetType, context) -> ((Optional)durationConverter.apply((CharSequence)object, context)).map(TemporalAmount.class::cast));
        BiFunction<CharSequence, ConversionContext, Optional<Period>> periodConverter = this.periodConverter();
        conversionService.addConverter(CharSequence.class, Period.class, (object, targetType, context) -> (Optional)periodConverter.apply((CharSequence)object, context));
        conversionService.addConverter(Integer.class, Period.class, (integer, targetType, context) -> (Optional)periodConverter.apply(integer.toString(), context));
        conversionService.addConverter(CharSequence.class, TemporalAmount.class, (object, targetType, context) -> ((Optional)periodConverter.apply((CharSequence)object, context)).map(TemporalAmount.class::cast));
        this.addTemporalStringConverters(conversionService, Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from);
        this.addTemporalStringConverters(conversionService, LocalDate.class, DateTimeFormatter.ISO_LOCAL_DATE, LocalDate::from);
        this.addTemporalStringConverters(conversionService, LocalDateTime.class, DateTimeFormatter.ISO_LOCAL_DATE_TIME, LocalDateTime::from);
        this.addTemporalStringConverters(conversionService, OffsetTime.class, DateTimeFormatter.ISO_OFFSET_TIME, OffsetTime::from);
        this.addTemporalStringConverters(conversionService, OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from);
        this.addTemporalStringConverters(conversionService, ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from);
        this.addTemporalStringConverters(conversionService, YearMonth.class, ISO_YEAR_MONTH, YearMonth::from);
        this.addTemporalStringConverters(conversionService, Year.class, ISO_YEAR, Year::from);
        this.addTemporalIntegerConverters(conversionService, Year.class, ISO_YEAR, Year::from);
        this.addTemporalStringConverters(conversionService, MonthDay.class, ISO_MONTH_DAY, MonthDay::from);
        this.addTemporalStringConverters(conversionService, LocalTime.class, DateTimeFormatter.ISO_LOCAL_TIME, LocalTime::from);
        conversionService.addConverter(CharSequence.class, ZoneId.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty((CharSequence)object)) {
                return Optional.empty();
            }
            try {
                ZoneId result = ZoneId.of(object.toString());
                return Optional.of(result);
            }
            catch (DateTimeParseException e) {
                context.reject(object, (Exception)e);
                return Optional.empty();
            }
        });
        conversionService.addConverter(ZoneId.class, CharSequence.class, (object, targetType, context) -> {
            if (Objects.isNull(object)) {
                return Optional.empty();
            }
            return Optional.of(object.toString());
        });
        this.addTemporalToDateConverter(conversionService, Instant.class, Function.identity());
        this.addTemporalToDateConverter(conversionService, OffsetDateTime.class, OffsetDateTime::toInstant);
        this.addTemporalToDateConverter(conversionService, ZonedDateTime.class, ChronoZonedDateTime::toInstant);
        this.addTemporalToDateConverter(conversionService, LocalDate.class, ld -> ld.atTime(0, 0).toInstant(ZoneOffset.UTC));
        this.addTemporalToDateConverter(conversionService, LocalDateTime.class, ldt -> ldt.toInstant(ZoneOffset.UTC));
    }

    private <T extends TemporalAccessor> void addTemporalStringConverters(MutableConversionService conversionService, Class<T> temporalType, DateTimeFormatter isoFormatter, TemporalQuery<T> query) {
        conversionService.addConverter(CharSequence.class, temporalType, (object, targetType, context) -> {
            if (StringUtils.isEmpty((CharSequence)object)) {
                return Optional.empty();
            }
            Optional format = context.getAnnotationMetadata().stringValue(Format.class);
            if (format.isPresent()) {
                DateTimeFormatter formatter = this.getFormatter((String)format.get(), context);
                try {
                    TemporalAccessor converted = (TemporalAccessor)formatter.parse((CharSequence)object, query);
                    return Optional.of(converted);
                }
                catch (DateTimeParseException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
            try {
                TemporalAccessor converted = (TemporalAccessor)isoFormatter.parse((CharSequence)object, query);
                return Optional.of(converted);
            }
            catch (DateTimeParseException converted) {
                try {
                    TemporalAccessor result = (TemporalAccessor)DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)object, query);
                    return Optional.of(result);
                }
                catch (DateTimeParseException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
        });
        conversionService.addConverter(temporalType, CharSequence.class, (object, targetType, context) -> {
            if (Objects.isNull(object)) {
                return Optional.empty();
            }
            Optional format = context.getAnnotationMetadata().stringValue(Format.class);
            if (format.isPresent()) {
                DateTimeFormatter formatter = this.getFormatter((String)format.get(), context);
                try {
                    String converted = formatter.format((TemporalAccessor)object);
                    return Optional.of(converted);
                }
                catch (DateTimeException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
            try {
                String converted = isoFormatter.format((TemporalAccessor)object);
                return Optional.of(converted);
            }
            catch (DateTimeException converted) {
                try {
                    String converted2 = DateTimeFormatter.RFC_1123_DATE_TIME.format((TemporalAccessor)object);
                    return Optional.of(converted2);
                }
                catch (DateTimeException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
        });
    }

    private <T extends TemporalAccessor> void addTemporalIntegerConverters(MutableConversionService conversionService, Class<T> temporalType, DateTimeFormatter isoFormatter, TemporalQuery<T> query) {
        conversionService.addConverter(Integer.class, temporalType, (object, targetType, context) -> {
            if (Objects.isNull(object)) {
                return Optional.empty();
            }
            Optional format = context.getAnnotationMetadata().stringValue(Format.class);
            if (format.isPresent()) {
                DateTimeFormatter formatter = this.getFormatter((String)format.get(), context);
                try {
                    TemporalAccessor converted = (TemporalAccessor)formatter.parse((CharSequence)object.toString(), query);
                    return Optional.of(converted);
                }
                catch (DateTimeParseException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
            try {
                TemporalAccessor converted = (TemporalAccessor)isoFormatter.parse((CharSequence)object.toString(), query);
                return Optional.of(converted);
            }
            catch (DateTimeParseException converted) {
                try {
                    TemporalAccessor result = (TemporalAccessor)DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)object.toString(), query);
                    return Optional.of(result);
                }
                catch (DateTimeParseException e) {
                    context.reject(object, (Exception)e);
                    return Optional.empty();
                }
            }
        });
    }

    private BiFunction<CharSequence, ConversionContext, Optional<Duration>> durationConverter() {
        return (object, context) -> {
            String value = object.toString().trim();
            if (value.startsWith("P")) {
                try {
                    return Optional.of(Duration.parse(value));
                }
                catch (DateTimeParseException e) {
                    context.reject((Object)value, (Exception)e);
                    return Optional.empty();
                }
            }
            Matcher matcher = DURATION_MATCHER.matcher(value);
            if (matcher.find()) {
                String amount = matcher.group(1);
                String g2 = matcher.group(2);
                char type = g2.charAt(0);
                try {
                    switch (type) {
                        case 's': {
                            return Optional.of(Duration.ofSeconds(Integer.parseInt(amount)));
                        }
                        case 'm': {
                            String ms = matcher.group(3);
                            if (StringUtils.hasText((CharSequence)ms)) {
                                return Optional.of(Duration.ofMillis(Integer.parseInt(amount)));
                            }
                            return Optional.of(Duration.ofMinutes(Integer.parseInt(amount)));
                        }
                        case 'h': {
                            return Optional.of(Duration.ofHours(Integer.parseInt(amount)));
                        }
                        case 'd': {
                            return Optional.of(Duration.ofDays(Integer.parseInt(amount)));
                        }
                    }
                    String seq = g2 + matcher.group(3);
                    if (seq.equals("ns")) {
                        return Optional.of(Duration.ofNanos(Integer.parseInt(amount)));
                    }
                    context.reject((Object)value, (Exception)new DateTimeParseException("Unparseable date format (" + value + "). Should either be a ISO-8601 duration or a round number followed by the unit type", value, 0));
                    return Optional.empty();
                }
                catch (NumberFormatException e) {
                    context.reject((Object)value, (Exception)e);
                }
            }
            return Optional.empty();
        };
    }

    private BiFunction<CharSequence, ConversionContext, Optional<Period>> periodConverter() {
        return (object, context) -> {
            String value = object.toString().trim();
            if (value.startsWith("P")) {
                try {
                    return Optional.of(Period.parse(value));
                }
                catch (DateTimeParseException e) {
                    context.reject((Object)value, (Exception)e);
                    return Optional.empty();
                }
            }
            Matcher matcher = PERIOD_MATCHER.matcher(value);
            if (matcher.find()) {
                String amount = matcher.group(1);
                String g2 = matcher.group(2);
                char type = g2.charAt(0);
                try {
                    switch (type) {
                        case 'y': {
                            return Optional.of(Period.ofYears(Integer.parseInt(amount)));
                        }
                        case 'm': {
                            return Optional.of(Period.ofMonths(Integer.parseInt(amount)));
                        }
                        case 'w': {
                            return Optional.of(Period.ofWeeks(Integer.parseInt(amount)));
                        }
                        case 'd': {
                            return Optional.of(Period.ofDays(Integer.parseInt(amount)));
                        }
                    }
                    context.reject((Object)value, (Exception)new DateTimeParseException("Unparseable date format (" + value + "). Should either be a ISO-8601 duration or a round number followed by the unit type", value, 0));
                    return Optional.empty();
                }
                catch (NumberFormatException e) {
                    context.reject((Object)value, (Exception)e);
                }
            }
            return Optional.empty();
        };
    }

    private DateTimeFormatter getFormatter(String pattern, ConversionContext context) {
        String key = pattern + context.getLocale();
        DateTimeFormatter cachedFormatter = this.formattersCache.get(key);
        if (cachedFormatter != null) {
            return cachedFormatter;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, context.getLocale());
        this.formattersCache.put(key, formatter);
        return formatter;
    }

    private <T extends TemporalAccessor> void addTemporalToDateConverter(MutableConversionService conversionService, Class<T> temporalType, Function<T, Instant> toInstant) {
        conversionService.addConverter(temporalType, Date.class, (object, targetType, context) -> Optional.of(Date.from((Instant)toInstant.apply(object))));
    }
}

