/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.format;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.FormattingTypeConverter;
import io.micronaut.core.convert.format.ReadableBytes;
import java.util.Locale;
import java.util.Optional;

public class ReadableBytesTypeConverter
implements FormattingTypeConverter<CharSequence, Number, ReadableBytes> {
    private static final int KB_UNIT = 1024;

    @Override
    public Class<ReadableBytes> annotationType() {
        return ReadableBytes.class;
    }

    @Override
    public Optional<Number> convert(CharSequence object, Class<Number> targetType, ConversionContext context) {
        String value = object.toString().toUpperCase(Locale.ENGLISH);
        try {
            if (value.endsWith("KB")) {
                long size = Long.valueOf(value.substring(0, value.length() - 2)) * 1024L;
                return ConversionService.SHARED.convert((Object)size, targetType);
            }
            if (value.endsWith("MB")) {
                long size = Long.valueOf(value.substring(0, value.length() - 2)) * 1024L * 1024L;
                return ConversionService.SHARED.convert((Object)size, targetType);
            }
            if (value.endsWith("GB")) {
                long size = Long.valueOf(value.substring(0, value.length() - 2)) * 1024L * 1024L * 1024L;
                return ConversionService.SHARED.convert((Object)size, targetType);
            }
            Long size = Long.valueOf(value);
            return ConversionService.SHARED.convert((Object)size, targetType);
        }
        catch (NumberFormatException e) {
            context.reject(value, e);
            return Optional.empty();
        }
    }
}

