/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.ValueResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public interface ConvertibleValues<V>
extends ValueResolver<CharSequence>,
Iterable<Map.Entry<String, V>> {
    public static final ConvertibleValues EMPTY = new ConvertibleValuesMap(Collections.emptyMap());

    public Set<String> names();

    public Collection<V> values();

    default public boolean isEmpty() {
        return this == EMPTY || this.names().isEmpty();
    }

    default public Class<V> getValueType() {
        Optional<Class> type = GenericTypeUtils.resolveInterfaceTypeArgument(this.getClass(), ConvertibleValues.class);
        return type.orElse(Object.class);
    }

    default public boolean contains(String name) {
        return this.get(name, Object.class).isPresent();
    }

    default public void forEach(BiConsumer<String, V> action) {
        Objects.requireNonNull(action, "Consumer cannot be null");
        Set<String> headerNames = this.names();
        for (String headerName : headerNames) {
            Optional<V> vOptional = this.get(headerName, this.getValueType());
            vOptional.ifPresent(v -> action.accept(headerName, v));
        }
    }

    default public Map<String, V> asMap() {
        LinkedHashMap<String, V> newMap = new LinkedHashMap<String, V>();
        for (Map.Entry<String, V> entry : this) {
            String key = entry.getKey();
            newMap.put(key, entry.getValue());
        }
        return newMap;
    }

    default public <KT, VT> Map<KT, VT> asMap(Class<KT> keyType, Class<VT> valueType) {
        LinkedHashMap newMap = new LinkedHashMap();
        for (Map.Entry<String, V> entry : this) {
            String key = entry.getKey();
            Optional convertedKey = ConversionService.SHARED.convert((Object)key, keyType);
            if (!convertedKey.isPresent()) continue;
            Optional<VT> convertedValue = ConversionService.SHARED.convert(entry.getValue(), valueType);
            convertedValue.ifPresent(vt -> newMap.put(convertedKey.get(), vt));
        }
        return newMap;
    }

    default public Properties asProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, V> entry : this) {
            String key = entry.getKey();
            V value = entry.getValue();
            if (!(value instanceof CharSequence) && !(value instanceof Number)) continue;
            props.setProperty(key, value.toString());
        }
        return props;
    }

    default public Map<String, V> subMap(String prefix, Class<V> valueType) {
        return this.subMap(prefix, Argument.of(valueType));
    }

    default public Map<String, V> subMap(String prefix, Argument<V> valueType) {
        return this.subMap(prefix, ConversionContext.of(valueType));
    }

    default public Map<String, V> subMap(String prefix, ArgumentConversionContext<V> valueType) {
        String finalPrefix = prefix + '.';
        return this.names().stream().filter(name -> name.startsWith(finalPrefix)).collect(Collectors.toMap(name -> name.substring(finalPrefix.length()), name -> this.get(name, valueType).orElse(null)));
    }

    @Override
    default public Iterator<Map.Entry<String, V>> iterator() {
        final Iterator<String> names = this.names().iterator();
        return new Iterator<Map.Entry<String, V>>(){

            @Override
            public boolean hasNext() {
                return names.hasNext();
            }

            @Override
            public Map.Entry<String, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final String name = (String)names.next();
                return new Map.Entry<String, V>(){

                    @Override
                    public String getKey() {
                        return name;
                    }

                    @Override
                    public V getValue() {
                        return ConvertibleValues.this.get(name, ConvertibleValues.this.getValueType()).orElse(null);
                    }

                    @Override
                    public V setValue(V value) {
                        throw new UnsupportedOperationException("Not mutable");
                    }
                };
            }
        };
    }

    public static <T> ConvertibleValues<T> of(Map<? extends CharSequence, T> values) {
        if (values == null) {
            return ConvertibleValuesMap.empty();
        }
        return new ConvertibleValuesMap<T>(values);
    }

    public static <V> ConvertibleValues<V> empty() {
        return EMPTY;
    }
}

